/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.bank;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundTransactionEnterMenuConfirmPacket;
import com.equestricraft.mod.prompt.TransactionDetails;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TransactionEnterMenu
extends Screen {
    private final UUID requestUuid;
    private final String message;
    private ECMultiLineField messageLabel = null;

    public static void showScreen(UUID requestUuid, String message) {
        TransactionEnterMenu screen = new TransactionEnterMenu(requestUuid, message);
        ScreenStack.getInstance().push(screen);
    }

    private TransactionEnterMenu(UUID requestUuid, String message) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("transaction.menu.title")));
        this.requestUuid = requestUuid;
        this.message = message;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.messageLabel = ECMultiLineField.Builder.start().withLabel(this.message).withWidth(this.f_96543_ - 40).withPosition(this.f_96543_ / 2, 30).centerAlign().complete();
        int y = this.messageLabel.getHeight() + 35;
        ECTextField valueBox = ECTextField.Builder.start(50, y, this.f_96543_ - 100).withLabel(I18n.getLabel("transaction.menu.field.amount.label")).withFilter(this::filter).complete();
        this.m_142416_((GuiEventListener)valueBox);
        ECTextField reasonBox = ECTextField.Builder.start(50, y += 20, this.f_96543_ - 100).withLabel(I18n.getLabel("transaction.menu.field.reason.label")).complete();
        this.m_142416_((GuiEventListener)reasonBox);
        String buttonLabel = I18n.getLabel("transaction.menu.button.confirm.label");
        int buttonWidth = GuiUtil.getStandardTextWidth(buttonLabel) + 40;
        ECButton completeButton = ECButton.Builder.start(this.f_96543_ / 2, y += 20, buttonWidth, 20).withLabel(buttonLabel).withOnClick(() -> {
            double value = Double.parseDouble(valueBox.getValue());
            String reason = reasonBox.getValue();
            TransactionDetails details = new TransactionDetails(value, reason);
            ServerBoundTransactionEnterMenuConfirmPacket packet = new ServerBoundTransactionEnterMenuConfirmPacket(this.requestUuid, details);
            Network.sendToServer(packet);
            this.m_7379_();
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)completeButton);
    }

    private boolean filter(String strValue) {
        if (strValue.isEmpty()) {
            return true;
        }
        return !this.isInputNumerical(strValue);
    }

    private boolean isInputNumerical(String strValue) {
        for (int i = 0; i < strValue.length(); ++i) {
            char c = strValue.charAt(i);
            if (this.isNumber(c)) continue;
            return true;
        }
        return false;
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        TransactionEnterMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.messageLabel.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

