/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.business;

import com.equestricraft.core.business.BusinessListItem;
import com.equestricraft.mod.business.BusinessSelectAction;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundBusinessSelectPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BusinessItemScreen
extends Screen {
    private final List<BusinessListItem> businessListItems;
    private final BusinessSelectAction action;

    public static void showScreen(List<BusinessListItem> businessListItems, BusinessSelectAction action) {
        BusinessItemScreen screen = new BusinessItemScreen(businessListItems, action);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected BusinessItemScreen(List<BusinessListItem> businessListItems, BusinessSelectAction action) {
        super((Component)ComponentUtil.buildColoredTextComponent("Businesses"));
        this.businessListItems = businessListItems;
        this.action = action;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.renderList();
    }

    private void renderList() {
        int x = 20;
        int y = 20;
        for (BusinessListItem businessItem : this.businessListItems) {
            int width = this.f_96547_.m_92895_(businessItem.businessName()) + 10;
            if (x > this.f_96543_ - (width - 5)) {
                x = 20;
                y += 25;
            }
            Button button = new Button(x, y, width, 20, (Component)ComponentUtil.buildColoredTextComponent(businessItem.businessName()), b -> this.onItemClick(businessItem));
            x += width + 5;
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void onItemClick(BusinessListItem businessListItem) {
        ServerBoundBusinessSelectPacket packet = new ServerBoundBusinessSelectPacket(businessListItem.businessId(), this.action);
        super.m_7379_();
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int val1, int val2, float val3) {
        this.m_7333_(poseStack);
        BusinessItemScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, val1, val2, val3);
    }
}

