/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.business;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.business.BusinessPublicRegisterPage;
import com.equestricraft.core.business.BusinessRegisterItem;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.business.BusinessPublicRegisterWidget;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundBusinessPublicRegisterPageChangePacket;
import com.equestricraft.mod.packet.ServerBoundBusinessSearchPageRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class BusinessPublicRegisterMenuScreen
extends PageScreen<BusinessPublicRegisterPage, BusinessRegisterItem, Object, String> {
    private final UUID requestId;
    private final Consumer<BusinessRegisterItem> onClick;
    private EditBox textBox;

    public static void showScreen(BusinessPublicRegisterPage page) {
        BusinessPublicRegisterMenuScreen.showScreen(page, null, null);
    }

    public static void showScreen(BusinessPublicRegisterPage page, UUID requestId, Consumer<BusinessRegisterItem> onClick) {
        BusinessPublicRegisterMenuScreen screen = new BusinessPublicRegisterMenuScreen(page, requestId, onClick);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private BusinessPublicRegisterMenuScreen(BusinessPublicRegisterPage page, UUID requestId, Consumer<BusinessRegisterItem> onClick) {
        super(I18n.getLabel("business.public-register.menu.title"), page);
        this.requestId = requestId;
        this.onClick = onClick;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initSearchComponents();
        this.initHeader();
        this.initRows();
    }

    private void initSearchComponents() {
        if (this.requestId != null) {
            this.textBox = new EditBox(this.f_96547_, 20, 25, 150, 15, (Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("business.public-register.menu.search.label")));
            this.m_142416_((GuiEventListener)this.textBox);
            this.m_94718_((GuiEventListener)this.textBox);
            ECButton searchButton = ECButton.Builder.start(180, 25, 70, 15).withLabel(I18n.getLabel("business.public-register.menu.search.button.label")).withOnClick(() -> {
                ServerBoundBusinessSearchPageRequestPacket packet = new ServerBoundBusinessSearchPageRequestPacket(this.requestId, ((BusinessPublicRegisterPage)this.page).getPageNumber(), this.textBox.m_94155_());
                Network.sendToServer(packet);
            }).complete();
            this.m_142416_((GuiEventListener)searchButton);
        }
    }

    private void initHeader() {
        int y = this.requestId != null ? 55 : 30;
        int headerWidth = this.f_96543_ - 20;
        ECField nameLabel = ECField.Builder.start(20, y, headerWidth).withValue(I18n.getLabel("business.public-register.menu.header.name.label")).complete();
        this.m_142416_((GuiEventListener)nameLabel);
        ECField ownerLabel = ECField.Builder.start(190, y, headerWidth).withValue(I18n.getLabel("business.public-register.menu.header.owner.label")).complete();
        this.m_142416_((GuiEventListener)ownerLabel);
        ECField statusLabel = ECField.Builder.start(300, y, headerWidth).withValue(I18n.getLabel("business.public-register.menu.header.status.label")).complete();
        this.m_142416_((GuiEventListener)statusLabel);
    }

    private void initRows() {
        int y = this.requestId != null ? 70 : 43;
        for (BusinessRegisterItem business : ((BusinessPublicRegisterPage)this.page).getItems()) {
            BusinessPublicRegisterWidget widget = new BusinessPublicRegisterWidget(10, y, this.f_96543_ - 20, business, this.onClick);
            this.m_142416_((GuiEventListener)widget);
            y += widget.m_93694_();
        }
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.requestId != null) {
            this.textBox.m_94120_();
        }
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundBusinessPublicRegisterPageChangePacket packet = new ServerBoundBusinessPublicRegisterPageChangePacket(newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        BusinessPublicRegisterMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

