/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.business;

import com.equestricraft.common.BusinessOwnershipType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.business.registration.BusinessRegistrationRequestDto;
import com.equestricraft.mod.business.BusinessCategoryDto;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECCheckbox;
import com.equestricraft.mod.client.gui.components.ECCheckboxGroup;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.client.gui.components.ScrollableList;
import com.equestricraft.mod.client.gui.components.ScrollableListItem;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundBusinessRegistrationRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RegisterBusinessMenu
extends Screen {
    private final List<BusinessCategoryDto> categories;

    public static void showScreen(List<BusinessCategoryDto> categories) {
        RegisterBusinessMenu screen = new RegisterBusinessMenu(categories);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected RegisterBusinessMenu(List<BusinessCategoryDto> categories) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("business.register-business.menu.title")));
        this.categories = categories;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECTextField nameField = ECTextField.Builder.start(10, 20, this.f_96543_ - 20).withLabel(I18n.getLabel("business.register-business.menu.field.name.label")).complete();
        ECCheckboxGroup typeGroup = new ECCheckboxGroup();
        ECCheckbox<BusinessOwnershipType> typeDoleTraderBox = ECCheckbox.Builder.start(30, 40).withGroup(typeGroup).withOptionValue(BusinessOwnershipType.SOLE_TRADER).withText(BusinessOwnershipType.SOLE_TRADER.getTranslatedName()).complete();
        ECCheckbox<BusinessOwnershipType> typePlcBox = ECCheckbox.Builder.start(160, 40).withGroup(typeGroup).withOptionValue(BusinessOwnershipType.PUBLIC_LIMITED_COMPANY).withText(BusinessOwnershipType.PUBLIC_LIMITED_COMPANY.getTranslatedName()).complete();
        List<ScrollableListItem> categorySliderOptions = this.categories.stream().map(c -> new ScrollableListItem(c.id(), c.name())).toList();
        ScrollableList categorySlider = new ScrollableList(10, 60, this.f_96543_, 20, categorySliderOptions, 10);
        ECTextField requestBodyField = ECTextField.Builder.start(10, 85, this.f_96543_ - 20).withLabel(I18n.getLabel("business.register-business.menu.field.details.label")).complete();
        ECButton submitButton = ECButton.Builder.start(this.f_96543_ / 2, 110, 120, 20).withLabel(I18n.getLabel("business.register-business.menu.button.send-application.label")).withOnClick(() -> {
            String name = nameField.getValue();
            Optional ownershipType = typeGroup.getSelected();
            if (ownershipType.isEmpty()) {
                return;
            }
            List<Integer> categoryIds = categorySlider.getSelected();
            String requestBody = requestBodyField.getValue();
            this.onSendApplication(name, (BusinessOwnershipType)((Object)((Object)ownershipType.get())), categoryIds, requestBody);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)nameField);
        this.m_142416_((GuiEventListener)typeDoleTraderBox);
        this.m_142416_((GuiEventListener)typePlcBox);
        this.m_142416_((GuiEventListener)categorySlider);
        this.m_142416_((GuiEventListener)requestBodyField);
        this.m_142416_((GuiEventListener)submitButton);
    }

    private void onSendApplication(String name, BusinessOwnershipType ownershipType, List<Integer> categoryIds, String requestBody) {
        this.m_7379_();
        BusinessRegistrationRequestDto request = new BusinessRegistrationRequestDto(name, ownershipType, requestBody, categoryIds);
        ServerBoundBusinessRegistrationRequestPacket packet = new ServerBoundBusinessRegistrationRequestPacket(request);
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        RegisterBusinessMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

