/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.chattag;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.chattag.ChatTagItem;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class ChatTagItemWidget
extends ECWidget {
    private final ECField nameComponent;
    private final ECField textComponent;
    private final ECMultiLineField descriptionLabel;
    private final ECButton selectButton;

    protected ChatTagItemWidget(int x, int y, int width, ChatTagItem item, Consumer<ChatTagItem> onSelect) {
        super(x, y, width, 70);
        this.nameComponent = ECField.Builder.start(this.dx(0), this.dy(0), width).withLabel(I18n.getLabel("chat-tags.menu.field.name")).withValue(item.name()).complete();
        this.textComponent = ECField.Builder.start(this.dx(0), this.dy(15), width).withLabel(I18n.getLabel("chat-tags.menu.field.tag")).withValue(item.tag()).complete();
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(item.description()).withPosition(this.dx(0), this.dy(30)).withWidth(width).complete();
        String buttonLabel = I18n.getLabel(item.isActive() ? "chat-tags.menu.button.remove.label" : "chat-tags.menu.button.set.label");
        this.selectButton = ECButton.Builder.start(this.dx(0), this.dy(30) + this.descriptionLabel.getHeight(), width, 15).withLabel(buttonLabel).withOnClick(() -> onSelect.accept(item)).complete();
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.selectButton.m_6375_(mouseX, mouseY, action);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameComponent.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.textComponent.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.descriptionLabel.render(poseStack);
        this.selectButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

