/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubCreateRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClubCreateMenuScreen
extends Screen {
    private final String cost;
    private ECTextField nameField;
    private ECTextField chatTagField;

    public static void showScreen(String cost) {
        ClubCreateMenuScreen screen = new ClubCreateMenuScreen(cost);
        ScreenStack.getInstance().push(screen);
    }

    private ClubCreateMenuScreen(String cost) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("club.create.menu.title")));
        this.cost = cost;
    }

    protected void m_7856_() {
        this.nameField = ECTextField.Builder.start(30, 45, this.f_96543_ - 60).withLabel(I18n.getLabel("club.create.menu.field.name.label")).complete();
        this.chatTagField = ECTextField.Builder.start(30, 65, this.f_96543_ - 60).withLabel(I18n.getLabel("club.create.menu.field.chat-tag.label")).complete();
        ECField costField = ECField.Builder.start(this.f_96543_ / 2, 85, this.f_96543_ - 60).withLabel(I18n.getLabel("club.create.menu.field.cost.label")).withValue(this.cost).centerAligned().complete();
        String createButtonLabel = I18n.getLabel("club.create.menu.button.confirm.label");
        int createButtonWidth = GuiUtil.getStandardTextWidth(createButtonLabel) + 20;
        ECButton confirmButton = ECButton.Builder.start(this.f_96543_ / 2, 105, createButtonWidth, 20).withLabel(createButtonLabel).withOnClick(() -> {
            this.m_7379_();
            ServerBoundClubCreateRequestPacket packet = new ServerBoundClubCreateRequestPacket(this.nameField.getValue(), this.chatTagField.getValue());
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)this.nameField);
        this.m_142416_((GuiEventListener)this.chatTagField);
        this.m_142416_((GuiEventListener)costField);
        this.m_142416_((GuiEventListener)confirmButton);
    }

    public boolean m_7933_(int keyPressed, int val2, int shift) {
        return this.nameField.m_7933_(keyPressed, val2, shift) || this.chatTagField.m_7933_(keyPressed, val2, shift) || super.m_7933_(keyPressed, val2, shift);
    }

    public boolean m_5534_(char typed, int shift) {
        return this.nameField.m_5534_(typed, shift) || this.chatTagField.m_5534_(typed, shift) || super.m_5534_(typed, shift);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubCreateMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

