/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubDetailsUpdatePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClubEditScreen
extends Screen {
    private final int clubId;
    private final String clubName;
    private final String clubTag;

    public static void showScreen(int clubId, String clubName, String clubTag) {
        ClubEditScreen screen = new ClubEditScreen(clubId, clubName, clubTag);
        ScreenStack.getInstance().push(screen);
    }

    private ClubEditScreen(int clubId, String clubName, String clubTag) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("club.edit.menu.title", clubName)));
        this.clubId = clubId;
        this.clubName = clubName;
        this.clubTag = clubTag;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        ECTextField nameField = ECTextField.Builder.start(30, 40, this.f_96543_ - 60).withLabel(I18n.getLabel("club.edit.menu.field.name.label")).withDefaultValue(this.clubName).complete();
        ECTextField tagField = ECTextField.Builder.start(30, 60, this.f_96543_ - 60).withLabel(I18n.getLabel("club.edit.menu.field.tag.label")).withDefaultValue(this.clubTag).complete();
        String saveButtonLabel = I18n.getLabel("club.edit.menu.button.save.label");
        int saveButtonWidth = GuiUtil.getStandardTextWidth(saveButtonLabel) + 20;
        ECButton saveButton = ECButton.Builder.start(this.f_96543_ / 2, 80, saveButtonWidth, 20).withLabel(saveButtonLabel).withOnClick(() -> {
            String name = nameField.getValue();
            String tag = tagField.getValue();
            ServerBoundClubDetailsUpdatePacket packet = new ServerBoundClubDetailsUpdatePacket(name, tag);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.m_142416_((GuiEventListener)nameField);
        this.m_142416_((GuiEventListener)tagField);
        this.m_142416_((GuiEventListener)saveButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubEditScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

