/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.ClubInfo;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class ClubItemWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField ownerField;
    private final ECField memberCountField;
    private final ECButton sendJoinRequestButton;

    protected ClubItemWidget(int x, int y, int width, int height, ClubInfo clubInfo, Consumer<ClubInfo> onSendJoinRequestClick) {
        super(x, y, width, height);
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(clubInfo.clubName()).complete();
        this.ownerField = ECField.Builder.start(this.dx(0), this.dy(15), width).withLabel(I18n.getLabel("club.list.menu.item.field.owner.label")).withValue(clubInfo.owner().ign()).complete();
        this.memberCountField = ECField.Builder.start(this.dx(0), this.dy(30), width).withLabel(I18n.getLabel("club.list.menu.item.field.member-count.label")).withValue(clubInfo.memberCount()).complete();
        this.sendJoinRequestButton = clubInfo.canSendJoinRequest() ? ECButton.Builder.start(this.dx(0), this.dy(45), width, 20).withLabel(I18n.getLabel("club.list.menu.item.button.send-join-request.label")).withOnClick(() -> onSendJoinRequestClick.accept(clubInfo)).complete() : null;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.ownerField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.memberCountField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.sendJoinRequestButton != null) {
            this.sendJoinRequestButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.sendJoinRequestButton != null && this.sendJoinRequestButton.m_6375_(mouseX, mouseY, action);
    }
}

