/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestPlayerInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.club.ClubJoinRequestLine;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.club.ClubJoinRequestPage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubAcceptJoinRequestPacket;
import com.equestricraft.mod.packet.ServerBoundClubDenyJoinRequestPacket;
import com.equestricraft.mod.packet.ServerBoundClubJoinRequestPageRequestPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ClubJoinRequestPageScreen
extends PageScreen<ClubJoinRequestPage, ClubJoinRequestPlayerInfo, Object, Object> {
    private final int clubId;

    public static void showScreen(int clubId, ClubJoinRequestPage page) {
        ClubJoinRequestPageScreen screen = new ClubJoinRequestPageScreen(clubId, page);
        ScreenStack.getInstance().push(screen);
    }

    private ClubJoinRequestPageScreen(int clubId, ClubJoinRequestPage page) {
        super(I18n.getLabel("club.join-requests.menu.title"), page);
        this.clubId = clubId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        this.initList();
    }

    private void initList() {
        int y = 35;
        for (ClubJoinRequestPlayerInfo item : ((ClubJoinRequestPage)this.page).getItems()) {
            ClubJoinRequestLine widget = new ClubJoinRequestLine(20, y, this.f_96543_ - 40, item, this::onAccept, this::onDeny);
            y += 25;
            this.m_142416_((GuiEventListener)widget);
        }
    }

    private void onAccept(ClubJoinRequestPlayerInfo info2) {
        this.m_7379_();
        ServerBoundClubAcceptJoinRequestPacket packet = new ServerBoundClubAcceptJoinRequestPacket(info2.player().id());
        Network.sendToServer(packet);
    }

    private void onDeny(ClubJoinRequestPlayerInfo info2) {
        this.m_7379_();
        ServerBoundClubDenyJoinRequestPacket packet = new ServerBoundClubDenyJoinRequestPacket(info2.player().id());
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundClubJoinRequestPageRequestPacket packet = new ServerBoundClubJoinRequestPageRequestPacket(this.clubId, newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubJoinRequestPageScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

