/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.ClubManageInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubDisbandPacket;
import com.equestricraft.mod.packet.ServerBoundClubEditMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundClubJoinRequestPageRequestPacket;
import com.equestricraft.mod.packet.ServerBoundClubMemberPageOpenPacket;
import com.equestricraft.mod.packet.ServerBoundClubRankPageOpenPacket;
import com.equestricraft.mod.packet.ServerBoundClubSendInvitePacket;
import com.equestricraft.mod.packet.ServerBoundClubSetAllowJoinRequestsPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClubManageMenuScreen
extends Screen {
    private final ClubManageInfo clubManageInfo;

    public static void showScreen(ClubManageInfo clubManageInfo) {
        ClubManageMenuScreen screen = new ClubManageMenuScreen(clubManageInfo);
        ScreenStack.getInstance().push(screen);
    }

    private ClubManageMenuScreen(ClubManageInfo clubManageInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("club.manage.menu.title", clubManageInfo.clubName())));
        this.clubManageInfo = clubManageInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 30;
        if (this.clubManageInfo.viewJoinRequests()) {
            ECButton joinRequestsButton = ECButton.Builder.start(this.f_96543_ / 2, y, 150, 20).withLabel(I18n.getLabel("club.manage.menu.button.view-join-requests.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubJoinRequestPageRequestPacket(this.clubManageInfo.clubId(), 1))).centerAligned().complete();
            this.m_142416_((GuiEventListener)joinRequestsButton);
            y += 25;
        }
        if (this.clubManageInfo.sendInvites()) {
            ECButton sendInviteButton = ECButton.Builder.start(this.f_96543_ / 2, y, 150, 20).withLabel(I18n.getLabel("club.manage.menu.button.send-invite.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubSendInvitePacket())).centerAligned().complete();
            this.m_142416_((GuiEventListener)sendInviteButton);
            y += 25;
        }
        if (this.clubManageInfo.viewMembers()) {
            ECButton viewClubMembers = ECButton.Builder.start(this.f_96543_ / 2, y, 150, 20).withLabel(I18n.getLabel("club.manage.menu.button.view-members.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubMemberPageOpenPacket(this.clubManageInfo.clubId(), 1))).centerAligned().complete();
            this.m_142416_((GuiEventListener)viewClubMembers);
            y += 25;
        }
        if (this.clubManageInfo.editDetails()) {
            ECButton editDetailsButton = ECButton.Builder.start(this.f_96543_ / 2, y, 150, 20).withLabel(I18n.getLabel("club.manage.menu.button.edit-details.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubEditMenuOpenPacket())).centerAligned().complete();
            this.m_142416_((GuiEventListener)editDetailsButton);
            ECButton manageRanksButton = ECButton.Builder.start(this.f_96543_ / 2, y += 25, 150, 20).withLabel(I18n.getLabel("club.manage.menu.button.manage-ranks.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubRankPageOpenPacket(this.clubManageInfo.clubId(), 1))).centerAligned().complete();
            this.m_142416_((GuiEventListener)manageRanksButton);
            ECButton.Builder toggleJoinRequestsBuilder = ECButton.Builder.start(this.f_96543_ / 2, y += 25, 150, 20);
            toggleJoinRequestsBuilder = this.clubManageInfo.joinRequestsEnabled() ? toggleJoinRequestsBuilder.withLabel(I18n.getLabel("club.manage.menu.button.turn-off-join-requests.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubSetAllowJoinRequestsPacket(false))) : toggleJoinRequestsBuilder.withLabel(I18n.getLabel("club.manage.menu.button.turn-on-join-requests.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubSetAllowJoinRequestsPacket(true)));
            ECButton toggleJoinRequestsButton = toggleJoinRequestsBuilder.centerAligned().complete();
            this.m_142416_((GuiEventListener)toggleJoinRequestsButton);
            y += 25;
        }
        if (this.clubManageInfo.disbandClub()) {
            ECButton disbandClubButton = ECButton.Builder.start(this.f_96543_ / 2, y, 150, 20).withLabel(I18n.getLabel("club.manage.menu.button.disband-club.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubDisbandPacket())).centerAligned().complete();
            this.m_142416_((GuiEventListener)disbandClubButton);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubManageMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

