/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.member.ClubMemberInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.club.ClubMemberWidget;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.club.ClubMemberPage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubKickMemberPacket;
import com.equestricraft.mod.packet.ServerBoundClubMemberPageOpenPacket;
import com.equestricraft.mod.packet.ServerBoundClubSetPlayerRankPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ClubMemberPageScreen
extends PageScreen<ClubMemberPage, ClubMemberInfo, Object, Object> {
    private final int clubId;

    public static void showScreen(int clubId, ClubMemberPage clubMemberPage) {
        ClubMemberPageScreen screen = new ClubMemberPageScreen(clubId, clubMemberPage);
        ScreenStack.getInstance().push(screen);
    }

    protected ClubMemberPageScreen(int clubId, ClubMemberPage page) {
        super(I18n.getLabel("club.members.menu.title"), page);
        this.clubId = clubId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        this.initList();
    }

    private void initList() {
        int x = 10;
        int y = 35;
        int widgetWidth = (this.f_96543_ - 20) / 4;
        for (ClubMemberInfo item : ((ClubMemberPage)this.page).getItems()) {
            ClubMemberWidget widget = new ClubMemberWidget(x, y, widgetWidth, 50, item, this::onKickClick, this::onSetRankClick);
            this.m_142416_((GuiEventListener)widget);
            if ((x += widgetWidth) + widgetWidth <= this.f_96543_ - 10) continue;
            x = 10;
            y += 55;
        }
    }

    private void onKickClick(ClubMemberInfo item) {
        this.m_7379_();
        ServerBoundClubKickMemberPacket packet = new ServerBoundClubKickMemberPacket(item.player().id());
        Network.sendToServer(packet);
    }

    private void onSetRankClick(ClubMemberInfo item) {
        this.m_7379_();
        ServerBoundClubSetPlayerRankPacket packet = new ServerBoundClubSetPlayerRankPacket(item.player().id());
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundClubMemberPageOpenPacket packet = new ServerBoundClubMemberPageOpenPacket(this.clubId, newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubMemberPageScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

