/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.member.ClubMemberInfo;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class ClubMemberWidget
extends ECWidget {
    private final ECField ignField;
    private final ECField rankField;
    private final ECButton kickButton;
    private final ECButton setRankButton;

    protected ClubMemberWidget(int x, int y, int width, int height, ClubMemberInfo item, Consumer<ClubMemberInfo> onKickClick, Consumer<ClubMemberInfo> onSetRankClick) {
        super(x, y, width, height);
        this.ignField = ECField.Builder.start(this.dx(0), this.dy(0), width).withLabel(I18n.getLabel("club.members.menu.item.field.ign.label")).withValue(item.player().ign()).complete();
        this.rankField = ECField.Builder.start(this.dx(0), this.dy(15), width).withLabel(I18n.getLabel("club.members.menu.item.field.rank.label")).withValue(this.determineRank(item)).complete();
        if (!item.owner()) {
            this.kickButton = ECButton.Builder.start(this.dx(0), this.dy(30), width, 20).withLabel(I18n.getLabel("club.members.menu.item.button.kick.label")).withOnClick(() -> onKickClick.accept(item)).complete();
            this.setRankButton = ECButton.Builder.start(this.dx(0), this.dy(50), width, 20).withLabel(I18n.getLabel("club.members.menu.item.button.set-rank.label")).withOnClick(() -> onSetRankClick.accept(item)).complete();
        } else {
            this.kickButton = null;
            this.setRankButton = null;
        }
    }

    private String determineRank(ClubMemberInfo clubMemberInfo) {
        if (clubMemberInfo.owner()) {
            return I18n.getLabel("club.rank.owner");
        }
        if (clubMemberInfo.rankName() != null) {
            return clubMemberInfo.rankName();
        }
        return I18n.getLabel("common.na");
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.ignField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.rankField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.kickButton != null) {
            this.kickButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.setRankButton != null) {
            this.setRankButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.kickButton != null && this.kickButton.m_6375_(mouseX, mouseY, action) || this.setRankButton != null && this.setRankButton.m_6375_(mouseX, mouseY, action);
    }
}

