/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.club.ClubCreateMenuScreen;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubListOpenPacket;
import com.equestricraft.mod.packet.ServerBoundClubManageRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClubOfficeMenuScreen
extends Screen {
    private final boolean canCreateClub;
    private final boolean canManageClub;
    private final String clubCreateCost;

    public static void showScreen(boolean canCreateClub, boolean canManageClub, String clubCreateCost) {
        ClubOfficeMenuScreen screen = new ClubOfficeMenuScreen(canCreateClub, canManageClub, clubCreateCost);
        ScreenStack.getInstance().push(screen);
    }

    private ClubOfficeMenuScreen(boolean canCreateClub, boolean canManageClub, String clubCreateCost) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("club.office.menu.title")));
        this.canCreateClub = canCreateClub;
        this.canManageClub = canManageClub;
        this.clubCreateCost = clubCreateCost;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 45;
        if (this.canCreateClub) {
            ECButton createClubButton = ECButton.Builder.start(this.f_96543_ / 2, y, 120, 20).withLabel(I18n.getLabel("club.office.menu.button.create-club.label")).withOnClick(() -> ClubCreateMenuScreen.showScreen(this.clubCreateCost)).centerAligned().complete();
            this.m_142416_((GuiEventListener)createClubButton);
            y += 25;
        }
        if (this.canManageClub) {
            ECButton manageClubButton = ECButton.Builder.start(this.f_96543_ / 2, y, 120, 20).withLabel(I18n.getLabel("club.office.menu.button.manage-club.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubManageRequestPacket())).centerAligned().complete();
            this.m_142416_((GuiEventListener)manageClubButton);
            y += 25;
        }
        ECButton viewClubsButton = ECButton.Builder.start(this.f_96543_ / 2, y, 120, 20).withLabel(I18n.getLabel("club.office.menu.button.view-clubs.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubListOpenPacket(1))).centerAligned().complete();
        this.m_142416_((GuiEventListener)viewClubsButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubOfficeMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)5, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

