/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.ClubInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.club.ClubItemWidget;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.club.ClubPage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubListOpenPacket;
import com.equestricraft.mod.packet.ServerBoundClubSendJoinRequestPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ClubPageScreen
extends PageScreen<ClubPage, ClubInfo, Object, Object> {
    public static void showScreen(ClubPage clubPage) {
        ClubPageScreen screen = new ClubPageScreen(clubPage);
        ScreenStack.getInstance().push(screen);
    }

    protected ClubPageScreen(ClubPage page) {
        super(I18n.getLabel("club.list.menu.title"), page);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        this.initList();
    }

    private void initList() {
        int x = 10;
        int y = 35;
        int widgetWidth = this.f_96543_ / 2 - 20;
        for (ClubInfo item : ((ClubPage)this.page).getItems()) {
            ClubItemWidget widget = new ClubItemWidget(x, y, widgetWidth, 70, item, this::onSendJoinRequestClick);
            this.m_142416_((GuiEventListener)widget);
            if ((x += widgetWidth + 2) + widgetWidth <= this.f_96543_ - 10) continue;
            x = 10;
            y += 75;
        }
    }

    private void onSendJoinRequestClick(ClubInfo clubInfo) {
        this.m_7379_();
        ServerBoundClubSendJoinRequestPacket packet = new ServerBoundClubSendJoinRequestPacket(clubInfo.clubId());
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundClubListOpenPacket packet = new ServerBoundClubListOpenPacket(newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubPageScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

