/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.rank.ClubRankInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.club.ClubRankWidget;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.club.ClubRankPage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundClubRankCreatePacket;
import com.equestricraft.mod.packet.ServerBoundClubRankEditLevelPacket;
import com.equestricraft.mod.packet.ServerBoundClubRankEditNamePacket;
import com.equestricraft.mod.packet.ServerBoundClubRankPageOpenPacket;
import com.equestricraft.mod.packet.ServerBoundClubRankSetDefaultPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ClubRankPageScreen
extends PageScreen<ClubRankPage, ClubRankInfo, Object, Object> {
    private final int clubId;

    public static void showScreen(int clubId, ClubRankPage page) {
        ClubRankPageScreen screen = new ClubRankPageScreen(clubId, page);
        ScreenStack.getInstance().push(screen);
    }

    private ClubRankPageScreen(int clubId, ClubRankPage page) {
        super(I18n.getLabel("club.ranks.menu.title"), page);
        this.clubId = clubId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        this.initList();
        this.initButtons();
    }

    private void initList() {
        int x = 10;
        int y = 35;
        int widgetWidth = (this.f_96543_ - 20) / 4;
        for (ClubRankInfo item : ((ClubRankPage)this.page).getItems()) {
            ClubRankWidget widget = new ClubRankWidget(x, y, widgetWidth, 90, item, this::onEditName, this::onEditLevel, this::onSetDefault);
            this.m_142416_((GuiEventListener)widget);
            if ((x += widgetWidth) + widgetWidth <= this.f_96543_ - 10) continue;
            x = 10;
            y += 95;
        }
    }

    private void onEditName(ClubRankInfo clubRankInfo) {
        ServerBoundClubRankEditNamePacket packet = new ServerBoundClubRankEditNamePacket(clubRankInfo.rankId());
        Network.sendToServer(packet);
    }

    private void onEditLevel(ClubRankInfo clubRankInfo) {
        ServerBoundClubRankEditLevelPacket packet = new ServerBoundClubRankEditLevelPacket(clubRankInfo.rankId());
        Network.sendToServer(packet);
    }

    private void onSetDefault(ClubRankInfo clubRankInfo) {
        ServerBoundClubRankSetDefaultPacket packet = new ServerBoundClubRankSetDefaultPacket(clubRankInfo.rankId());
        Network.sendToServer(packet);
    }

    private void initButtons() {
        ECButton createRankButton = ECButton.Builder.start(40, this.f_96544_ - 25, 100, 20).withLabel(I18n.getLabel("club.ranks.menu.button.create.label")).withOnClick(() -> Network.sendToServer(new ServerBoundClubRankCreatePacket())).complete();
        this.m_142416_((GuiEventListener)createRankButton);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundClubRankPageOpenPacket packet = new ServerBoundClubRankPageOpenPacket(this.clubId, newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ClubRankPageScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

