/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.club;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.rank.ClubRankInfo;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class ClubRankWidget
extends ECWidget {
    private final ECField rankNameField;
    private final ECField permissionLevelField;
    private final ECButton editNameButton;
    private final ECButton editPermissionLevelButton;
    private final ECButton setDefaultRankButton;

    protected ClubRankWidget(int x, int y, int width, int height, ClubRankInfo clubRankInfo, Consumer<ClubRankInfo> editNameClick, Consumer<ClubRankInfo> editLevelClick, Consumer<ClubRankInfo> setDefaultClick) {
        super(x, y, width, height);
        this.rankNameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withLabel(I18n.getLabel("club.ranks.menu.item.field.name.label")).withValue(clubRankInfo.rankName()).complete();
        this.permissionLevelField = ECField.Builder.start(this.dx(0), this.dy(15), width).withLabel(I18n.getLabel("club.ranks.menu.item.field.permission.label")).withValue(clubRankInfo.permissionLevel().getTranslatedName()).complete();
        this.editNameButton = ECButton.Builder.start(this.dx(0), this.dy(30), width, 20).withLabel(I18n.getLabel("club.ranks.menu.item.button.edit-name.label")).withOnClick(() -> editNameClick.accept(clubRankInfo)).complete();
        this.editPermissionLevelButton = ECButton.Builder.start(this.dx(0), this.dy(50), width, 20).withLabel(I18n.getLabel("club.ranks.menu.item.button.edit-permission-level.label")).withOnClick(() -> editLevelClick.accept(clubRankInfo)).complete();
        this.setDefaultRankButton = !clubRankInfo.defaultRank() ? ECButton.Builder.start(this.dx(0), this.dy(70), width, 20).withLabel(I18n.getLabel("club.ranks.menu.item.button.set-default.label")).withOnClick(() -> setDefaultClick.accept(clubRankInfo)).complete() : null;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.rankNameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.permissionLevelField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.editNameButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.editPermissionLevelButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.setDefaultRankButton != null) {
            this.setDefaultRankButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.editNameButton.m_6375_(mouseX, mouseY, action) || this.editPermissionLevelButton.m_6375_(mouseX, mouseY, action) || this.setDefaultRankButton != null && this.setDefaultRankButton.m_6375_(mouseX, mouseY, action);
    }
}

