/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.compendium;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.compendium.CompendiumGroup;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundCompendiumMenuOpenPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompendiumMainMenuScreen
extends Screen {
    private final List<CompendiumGroup> groups;

    public static void showCompendiumMenu(List<CompendiumGroup> groups2) {
        CompendiumMainMenuScreen screen = new CompendiumMainMenuScreen(groups2);
        ScreenStack.getInstance().push(screen);
    }

    private CompendiumMainMenuScreen(List<CompendiumGroup> groups2) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("compendium-menu.main.title")));
        this.groups = groups2;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 90;
        for (CompendiumGroup group : this.groups) {
            ECButton compendiumCharactersButton = ECButton.Builder.start(this.f_96543_ / 2, y, 150, 20).withLabel(group.label()).withOnClick(() -> Network.sendToServer(new ServerBoundCompendiumMenuOpenPacket(group.identifier()))).centerAligned().complete();
            this.m_142416_((GuiEventListener)compendiumCharactersButton);
            y += 30;
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        CompendiumMainMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

