/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.compendium;

import com.equestricraft.core.compendium.CompendiumGroupDetail;
import com.equestricraft.core.compendium.CompendiumItem;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.compendium.CompendiumItemInfoScreen;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompendiumMenuItemScreen
extends Screen {
    private final CompendiumGroupDetail compendiumGroupDetail;
    private static final int X_MARGIN = 10;

    public static void showScreen(CompendiumGroupDetail compendiumGroupDetail) {
        CompendiumMenuItemScreen screen = new CompendiumMenuItemScreen(compendiumGroupDetail);
        ScreenStack.getInstance().push(screen);
    }

    private CompendiumMenuItemScreen(CompendiumGroupDetail compendiumGroupDetail) {
        super((Component)ComponentUtil.buildColoredTextComponent(compendiumGroupDetail.name()));
        this.compendiumGroupDetail = compendiumGroupDetail;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.renderList();
    }

    private void renderList() {
        int x = 10;
        int y = 35;
        for (CompendiumItem compendiumItem : this.compendiumGroupDetail.items()) {
            int width = this.f_96547_.m_92895_(compendiumItem.getTitle()) + 10;
            ECButton widget = ECButton.Builder.start(x, y, width, 20).withLabel(compendiumItem.getTitle()).withOnClick(() -> this.onItemClick(compendiumItem)).withDisabled(!compendiumItem.isUnlocked()).complete();
            this.m_142416_((GuiEventListener)widget);
            if ((x += width + 5) <= this.f_96543_ - 20) continue;
            x = 10;
            y += 30;
        }
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
    }

    private void onItemClick(CompendiumItem compendiumItem) {
        if (compendiumItem.isUnlocked()) {
            CompendiumItemInfoScreen.showCompendiumItemInfo(compendiumItem);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        CompendiumMenuItemScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

