/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Argb;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;

public class AreaDisplayWidget
extends ECWidget {
    private final List<Area2D> areas;
    private final Argb color;

    public AreaDisplayWidget(int x, int y, int width, int height, List<Area2D> areas, Argb color) {
        super(x, y, width, height);
        this.areas = this.prepareAreas(areas);
        this.color = color;
    }

    private List<Area2D> prepareAreas(List<Area2D> areas) {
        Area2D enclosingArea = this.buildEnclosingArea(areas);
        int xOffset = -enclosingArea.x1();
        int zOffset = -enclosingArea.z1();
        float factor = enclosingArea.x2() > enclosingArea.z2() ? (float)((double)this.f_93618_ / (double)(enclosingArea.x2() + xOffset)) : (float)((double)this.f_93619_ / (double)(enclosingArea.z2() + zOffset));
        areas = areas.stream().map(a -> a.shiftX(xOffset).shiftZ(zOffset)).map(a -> a.transformScale(factor)).toList();
        return areas;
    }

    private Area2D buildEnclosingArea(List<Area2D> areas) {
        if (areas.isEmpty()) {
            throw new IllegalArgumentException("No areas provided");
        }
        Integer left = null;
        Integer right = null;
        Integer top = null;
        Integer bottom = null;
        for (Area2D area : areas) {
            if (left == null || area.x1() < left) {
                left = area.x1();
            }
            if (top == null || area.z1() < top) {
                top = area.z1();
            }
            if (right == null || area.x2() > right) {
                right = area.x2();
            }
            if (bottom != null && area.z2() <= bottom) continue;
            bottom = area.z2();
        }
        return new Area2D(left, right, top, bottom);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        for (Area2D area : this.areas) {
            AreaDisplayWidget.m_93172_((PoseStack)poseStack, (int)this.dx(area.x1()), (int)this.dy(area.z1()), (int)this.dx(area.x2()), (int)this.dy(area.z2()), (int)this.color.getIntValue());
        }
    }
}

