/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECAlignment;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;

public class ECButton
extends ECWidget {
    private final ECField textField;
    private final Runnable onClick;
    private final Argb buttonColor;
    private final boolean disabled;
    private final ResourceLocation icon;
    private final int iconWidth;
    private final int iconHeight;
    private final int defaultTransparency;
    private final int hoverTransparency;

    public ECButton(int x, int y, int width, int height, String label, Runnable onClick) {
        this(x, y, width, height, label, Argb.ARGB_AQUA, Argb.ARGB_WHITE, false, onClick, ECAlignment.LEFT, null, 0, 0, 30, 100);
    }

    private ECButton(int x, int y, int width, int height, String label, Argb labelColor, Argb buttonColor, boolean disabled, Runnable onClick, ECAlignment alignment, ResourceLocation icon, int iconWidth, int iconHeight, int defaultTransparency, int hoverTransparency) {
        super(x, y, width, height);
        this.onClick = onClick;
        this.buttonColor = buttonColor;
        this.disabled = disabled;
        this.icon = icon;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.f_93620_ = this.determineXForAlignment(x, width, alignment);
        ECField.Builder textFieldBuilder = ECField.Builder.start(this.dx(width / 2), this.dy(height / 2 - GuiUtil.getSpacedLineHeight() / 2), width - 10).withValue(label).withValueColor(disabled ? Argb.ARGB_MC_GRAY : labelColor).centerAligned();
        this.textField = textFieldBuilder.complete();
        this.defaultTransparency = defaultTransparency;
        this.hoverTransparency = hoverTransparency;
    }

    private int determineXForAlignment(int x, int width, ECAlignment alignment) {
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case ECAlignment.LEFT -> x;
            case ECAlignment.CENTER -> x - width / 2;
            case ECAlignment.RIGHT -> x - width;
        };
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (!this.disabled) {
            this.onClick.run();
        }
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Argb color = !this.disabled && this.isWithin(mouseX, mouseY) ? this.buttonColor.withTransparency(this.hoverTransparency) : this.buttonColor.withTransparency(this.defaultTransparency);
        GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, color);
        this.textField.f_93621_ = this.dy(this.f_93619_ / 2 - GuiUtil.getSpacedLineHeight() / 2);
        this.textField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.icon != null) {
            int width = this.iconWidth != 0 ? this.iconWidth : GuiUtil.getSpacedLineHeight();
            int height = this.iconHeight != 0 ? this.iconHeight : GuiUtil.getSpacedLineHeight();
            GuiUtil.drawImage(poseStack, this.icon, this.dx(0), this.dy(0), width, height);
        }
    }

    public void setLabel(String label) {
        this.textField.setValue(label);
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private String label;
        private Argb labelColor = Argb.ARGB_AQUA;
        private Argb buttonColor = Argb.ARGB_WHITE;
        private boolean disabled = false;
        private Runnable onClick = null;
        private ECAlignment alignment = ECAlignment.LEFT;
        private ResourceLocation icon = null;
        private int iconWidth = 0;
        private int iconHeight = 0;
        private int defaultTransparency = 30;
        private int hoverTransparency = 100;

        private Builder(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withLabelColor(Argb labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder withButtonColor(Argb buttonColor) {
            this.buttonColor = buttonColor;
            return this;
        }

        public Builder withDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder withOnClick(Runnable onClick) {
            this.onClick = onClick;
            return this;
        }

        public Builder leftAligned() {
            return this.withAlignment(ECAlignment.LEFT);
        }

        public Builder centerAligned() {
            return this.withAlignment(ECAlignment.CENTER);
        }

        public Builder rightAligned() {
            return this.withAlignment(ECAlignment.RIGHT);
        }

        public Builder withAlignment(ECAlignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder withIcon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder withIcon(ResourceLocation icon, int width, int height) {
            this.icon = icon;
            this.iconWidth = width;
            this.iconHeight = height;
            return this;
        }

        public Builder withDefaultTransparency(int defaultTransparency) {
            this.defaultTransparency = defaultTransparency;
            return this;
        }

        public Builder withHoverTransparency(int hoverTransparency) {
            this.hoverTransparency = hoverTransparency;
            return this;
        }

        public ECButton complete() {
            return new ECButton(this.x, this.y, this.width, this.height, this.label, this.labelColor, this.buttonColor, this.disabled, this.onClick, this.alignment, this.icon, this.iconWidth, this.iconHeight, this.defaultTransparency, this.hoverTransparency);
        }

        public static Builder start(int x, int y, int width, int height) {
            return new Builder(x, y, width, height);
        }
    }
}

