/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECCheckboxGroup;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ECCheckbox<T>
extends ECWidget {
    private static final ResourceLocation TEXTURE_UNCHECKED = Resources.getTextures().getGui().get("check_box.png");
    private static final ResourceLocation TEXTURE_CHECKED = Resources.getTextures().getGui().get("check_box_checked.png");
    private final String message;
    private final Consumer<ECCheckbox<T>> onClick;
    private final T optionValue;
    private final ECCheckboxGroup<T> group;
    private boolean selected;

    private ECCheckbox(int x, int y, String message, boolean selected, Consumer<ECCheckbox<T>> onPress, T optionValue, ECCheckboxGroup<T> group) {
        super(x, y, 0, 20);
        this.message = message;
        this.selected = selected;
        this.optionValue = optionValue;
        this.onClick = onPress;
        this.group = group;
        if (group != null) {
            group.add(this);
        }
        int messageWidth = GuiUtil.getStandardTextWidth(message);
        this.m_93674_(22 + messageWidth);
    }

    public T getOptionValue() {
        return this.optionValue;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void select() {
        this.selected = true;
        if (this.group != null) {
            this.group.unselectOtherCheckboxes(this);
        }
    }

    public void deselect() {
        this.selected = false;
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.group == null) {
            if (this.isSelected()) {
                this.deselect();
            } else {
                this.select();
            }
        } else {
            this.select();
        }
        if (this.onClick != null) {
            this.onClick.accept(this);
        }
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        GuiUtil.drawImage(poseStack, this.selected ? TEXTURE_CHECKED : TEXTURE_UNCHECKED, this.dx(0), this.dy(0), 14, 14);
        ECCheckbox.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.message, (int)this.dx(22), (int)this.dy(3), (int)GuiConstants.COLOR_WHITE);
    }

    public static class Builder<T> {
        private final int x;
        private final int y;
        private String test;
        private boolean selected = false;
        private Consumer<ECCheckbox<T>> onClick;
        private T optionValue;
        private ECCheckboxGroup<T> group;

        private Builder(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Builder<T> withText(String text) {
            this.test = text;
            return this;
        }

        public Builder<T> withDefaultSelected(boolean selected) {
            this.selected = selected;
            return this;
        }

        public Builder<T> withOnClick(Consumer<ECCheckbox<T>> onClick) {
            this.onClick = onClick;
            return this;
        }

        public Builder<T> withOptionValue(T optionValue) {
            this.optionValue = optionValue;
            return this;
        }

        public Builder<T> withGroup(ECCheckboxGroup<T> group) {
            this.group = group;
            return this;
        }

        public ECCheckbox<T> complete() {
            return new ECCheckbox<T>(this.x, this.y, this.test, this.selected, this.onClick, this.optionValue, this.group);
        }

        public static <T> Builder<T> start(int x, int y) {
            return new Builder<T>(x, y);
        }
    }
}

