/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECAlignment;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class ECField
extends ECWidget {
    private final int baseX;
    private final String label;
    private Argb valueColor;
    private TextComponent component;
    private final TextComponent toolTip;
    private final Consumer<Integer> onClick;
    private final ECAlignment alignment;
    private Object currentValue;

    private ECField(int x, int y, int width, String label, Object value, Argb valueColor, String toolTip, Consumer<Integer> onClick, ECAlignment alignment) {
        super(x, y, width, 0);
        this.baseX = x;
        this.label = label;
        this.valueColor = valueColor;
        this.alignment = alignment;
        this.setValue(value);
        this.toolTip = toolTip != null ? ComponentUtil.buildColoredTextComponent(toolTip) : null;
        this.onClick = onClick;
        this.setHeight(GuiUtil.getSpacedLineHeight());
    }

    public void setValue(Object value) {
        this.currentValue = value;
        Object text = "";
        if (this.label != null) {
            text = (String)text + "&7" + this.label;
            if (value != null) {
                text = (String)text + ": ";
            }
        }
        this.component = ComponentUtil.buildColoredTextComponent((String)text);
        if (value != null) {
            if (this.valueColor != null) {
                TextComponent valueComponent = ComponentUtil.buildColoredTextComponent(value.toString());
                Style style = valueComponent.m_7383_().m_178520_(this.valueColor.getIntValue());
                valueComponent.m_6270_(style);
                this.component.m_7220_((Component)valueComponent);
            } else {
                this.component.m_7220_((Component)ComponentUtil.buildColoredTextComponent("&b" + value));
            }
        }
        this.f_93618_ = GuiUtil.getStandardTextWidth((Component)this.component);
        this.f_93620_ = switch (this.alignment) {
            default -> throw new IncompatibleClassChangeError();
            case ECAlignment.LEFT -> this.baseX;
            case ECAlignment.CENTER -> this.baseX - this.f_93618_ / 2;
            case ECAlignment.RIGHT -> this.baseX - this.f_93618_;
        };
    }

    public void setValueColor(Argb valueColor) {
        this.valueColor = valueColor;
        this.setValue(this.currentValue);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ECField.m_93243_((PoseStack)poseStack, (Font)this.getFont(), (Component)this.component, (int)this.dx(0), (int)this.dy(0), (int)GuiConstants.COLOR_WHITE);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.onClick != null) {
            this.onClick.accept(action);
            return true;
        }
        return false;
    }

    public TextComponent getToolTip() {
        return this.toolTip;
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private String label;
        private Object value;
        private Argb valueColor;
        private String toolTip;
        private Consumer<Integer> onClick;
        private ECAlignment alignment = ECAlignment.LEFT;

        private Builder(int x, int y, int width) {
            this.x = x;
            this.y = y;
            this.width = width;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withValue(Object value) {
            this.value = value;
            return this;
        }

        public Builder withValueColor(Argb valueColor) {
            this.valueColor = valueColor;
            return this;
        }

        public Builder withToolTip(String toolTip) {
            this.toolTip = toolTip;
            return this;
        }

        public Builder withOnClick(Consumer<Integer> onClick) {
            this.onClick = onClick;
            return this;
        }

        public Builder leftAligned() {
            return this.withAlignment(ECAlignment.LEFT);
        }

        public Builder centerAligned() {
            return this.withAlignment(ECAlignment.CENTER);
        }

        public Builder rightAligned() {
            return this.withAlignment(ECAlignment.RIGHT);
        }

        public Builder withAlignment(ECAlignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public ECField complete() {
            return new ECField(this.x, this.y, this.width, this.label, this.value, this.valueColor, this.toolTip, this.onClick, this.alignment);
        }

        public static Builder start(int x, int y, int width) {
            return new Builder(x, y, width);
        }
    }
}

