/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECAlignment;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.FormattedText;

public class ECMultiLineField {
    private final MultiLineLabel label;
    private int x;
    private int y;
    private final int spacing;
    private final int width;
    private final ECAlignment alignment;
    private Argb color;

    private ECMultiLineField(String label, int x, int y, int spacing, int width, ECAlignment alignment, Argb color) {
        this.label = MultiLineLabel.m_94341_((Font)Minecraft.m_91087_().f_91062_, (FormattedText)ComponentUtil.buildColoredTextComponent(label), (int)width);
        this.x = x;
        this.y = y;
        this.spacing = spacing;
        this.width = width;
        this.alignment = alignment;
        this.color = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.label.m_5770_() * this.getLineHeight();
    }

    public int getLineHeight() {
        return GuiUtil.getStandardLineHeight() + this.spacing;
    }

    public ECMultiLineField position(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ECMultiLineField color(Argb color) {
        this.color = color;
        return this;
    }

    public void render(PoseStack poseStack) {
        switch (this.alignment) {
            case LEFT: {
                this.label.m_6516_(poseStack, this.x, this.y, this.getLineHeight(), this.color.getIntValue());
                break;
            }
            case CENTER: {
                this.label.m_6514_(poseStack, this.x, this.y, this.getLineHeight(), this.color.getIntValue());
                break;
            }
            case RIGHT: {
                this.label.m_6516_(poseStack, this.x + this.getWidth(), this.y, this.getLineHeight(), this.color.getIntValue());
            }
        }
    }

    public static class Builder {
        private String label;
        private int x = 0;
        private int y = 0;
        private int spacing = 2;
        private int width = 0;
        private ECAlignment alignment = ECAlignment.LEFT;
        private Argb color = Argb.ARGB_WHITE;

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder withSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withAlignment(ECAlignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder leftAlign() {
            return this.withAlignment(ECAlignment.LEFT);
        }

        public Builder centerAlign() {
            return this.withAlignment(ECAlignment.CENTER);
        }

        public Builder rightAlign() {
            return this.withAlignment(ECAlignment.RIGHT);
        }

        public Builder withColor(Argb color) {
            this.color = color;
            return this;
        }

        public ECMultiLineField complete() {
            Objects.requireNonNull(this.label, "Must provide some text");
            if (this.width == 0) {
                throw new IllegalArgumentException("Width not defined");
            }
            return new ECMultiLineField(this.label, this.x, this.y, this.spacing, this.width, this.alignment, this.color);
        }

        public static Builder start() {
            return new Builder();
        }
    }
}

