/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Range;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ECNumberSpinner
extends ECWidget {
    private static final ResourceLocation ARROW = Resources.getTextures().getGui().get("arrow.png");
    private final String label;
    private final int labelWidth;
    private final Integer minValue;
    private final Integer maxValue;
    private final ImageButton increase;
    private final ImageButton decrease;
    private int value;
    private Consumer<Integer> valueChangeAction = null;

    private ECNumberSpinner(int x, int y, Integer minValue, Integer maxValue, String label, Integer value) {
        super(x, y, 11, 11 * GuiUtil.getSpacedLineHeight());
        this.label = label;
        this.labelWidth = GuiUtil.getStandardTextWidth(label);
        this.value = value != null ? value : 0;
        this.minValue = minValue;
        this.maxValue = maxValue;
        int lineHeight = GuiUtil.getSpacedLineHeight() / 2;
        this.increase = new ImageButton(this.dx(this.labelWidth + 2), this.dy(-lineHeight - 5 - 1), 11, 11, 0, 0, 0, ARROW, 11, 11, b -> this.onUpClick(), (Component)new TextComponent(I18n.getLabel("gui.generic-component.number-input.increase")));
        this.decrease = new ImageButton(this.dx(this.labelWidth + 2), this.dy(lineHeight + 2), 11, 11, 0, 0, 0, ARROW, 11, -11, b -> this.onDownClick(), (Component)new TextComponent(I18n.getLabel("gui.generic-component.number-input.decrease")));
        this.m_93674_(this.labelWidth + 2 + 11);
    }

    private void onUpClick() {
        if (this.maxValue == null || this.value < this.maxValue) {
            ++this.value;
            this.fireValueChange();
        }
    }

    private void onDownClick() {
        if (this.minValue == null || this.value > this.minValue) {
            --this.value;
            this.fireValueChange();
        }
    }

    private void fireValueChange() {
        if (this.valueChangeAction != null) {
            this.valueChangeAction.accept(this.value);
        }
    }

    public void onValueChange(Consumer<Integer> valueChangeAction) {
        this.valueChangeAction = valueChangeAction;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.m_91087_().f_91062_;
        ECNumberSpinner.m_93236_((PoseStack)poseStack, (Font)font, (String)this.label, (int)this.dx(0), (int)this.dy(0), (int)GuiConstants.COLOR_WHITE);
        ECNumberSpinner.m_93236_((PoseStack)poseStack, (Font)font, (String)String.valueOf(this.value), (int)this.dx(this.labelWidth + 5), (int)this.dy(0), (int)GuiConstants.COLOR_WHITE);
        this.increase.f_93620_ = this.dx(this.labelWidth + 2);
        this.decrease.f_93620_ = this.dx(this.labelWidth + 2);
        this.increase.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.decrease.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int action) {
        return this.decrease.m_6375_(mouseX, mouseY, action) || this.increase.m_6375_(mouseX, mouseY, action);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    @Override
    public boolean m_6050_(double x, double y, double scroll) {
        if (scroll > 0.0) {
            this.increase.m_5691_();
        } else if (scroll < 0.0) {
            this.decrease.m_5691_();
        }
        return super.m_6050_(x, y, scroll);
    }

    public static class Builder {
        private final int x;
        private final int y;
        private String label;
        private Integer minValue;
        private Integer maxValue;
        private Integer initialValue;

        private Builder(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withMinValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder withMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder withInitialValue(int initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public ECNumberSpinner complete() {
            this.validate();
            return new ECNumberSpinner(this.x, this.y, this.minValue, this.maxValue, this.label, this.initialValue);
        }

        private void validate() {
            if (this.initialValue != null && !Range.of(this.minValue, this.maxValue).containsValueWithin(this.initialValue)) {
                throw new IllegalArgumentException("Invalid range");
            }
        }

        public static Builder start(int x, int y) {
            return new Builder(x, y);
        }
    }
}

