/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Argb;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECAlignment;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.TextComponent;

public class ECProgressBar
extends ECWidget {
    private final String label;
    private final int labelWidth;
    private int value;
    private Argb filledColor;
    private Argb emptyColor;
    private final TextComponent toolTip;
    private int tabSize = 0;
    private int filledWidth = 0;
    private int barWidth = 0;

    private ECProgressBar(int x, int y, int width, String label, int value, Argb filledColor, Argb emptyColor, String toolTip, ECAlignment alignment) {
        super(x, y, width, GuiUtil.getStandardLineHeight());
        if (label != null) {
            this.label = label + ": ";
            this.labelWidth = GuiUtil.getStandardTextWidth(this.label);
        } else {
            this.label = null;
            this.labelWidth = 0;
        }
        this.setValue(value);
        this.filledColor = filledColor;
        this.emptyColor = emptyColor;
        this.toolTip = toolTip != null ? ComponentUtil.buildColoredTextComponent(toolTip) : null;
        this.f_93620_ = switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case ECAlignment.LEFT -> x;
            case ECAlignment.CENTER -> x - width / 2;
            case ECAlignment.RIGHT -> x - width;
        };
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = NumberUtils.keepWithinRange(value, 0, 100);
        this.barWidth = this.f_93618_ - (this.tabSize == 0 ? this.labelWidth : this.tabSize);
        this.filledWidth = PercentageUtils.of(this.barWidth, value);
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
        this.setValue(this.value);
    }

    public void setFilledColor(Argb filledColor) {
        this.filledColor = filledColor;
    }

    public void setEmptyColor(Argb emptyColor) {
        this.emptyColor = emptyColor;
    }

    public TextComponent getToolTip() {
        return this.toolTip;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ECProgressBar.m_93236_((PoseStack)poseStack, (Font)this.getFont(), (String)this.label, (int)this.dx(0), (int)this.dy(0), (int)GuiConstants.COLOR_GRAY);
        int filledStart = this.tabSize == 0 ? this.labelWidth : this.tabSize;
        GuiUtil.drawFilledSquare(poseStack, this.dx(filledStart), this.dy(0), this.filledWidth, this.f_93619_, this.filledColor);
        if (this.emptyColor != null) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(filledStart + this.filledWidth), this.dy(0), this.barWidth - this.filledWidth, this.f_93619_, this.emptyColor);
        }
        GuiUtil.drawSquare(poseStack, this.dx(this.tabSize == 0 ? this.labelWidth : this.tabSize), this.dy(0), this.barWidth, this.f_93619_, 1, Argb.ARGB_MC_GRAY);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private String label;
        private int value;
        private Argb filledColor = Argb.ARGB_GREEN;
        private Argb emptyColor = null;
        private String toolTip;
        private ECAlignment alignment = ECAlignment.LEFT;

        private Builder(int x, int y, int width) {
            this.x = x;
            this.y = y;
            this.width = width;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withValue(int value) {
            this.value = value;
            return this;
        }

        public Builder withFilledColor(Argb filledColor) {
            this.filledColor = filledColor;
            return this;
        }

        public Builder withEmptyColor(Argb emptyColor) {
            this.emptyColor = emptyColor;
            return this;
        }

        public Builder withToolTip(String toolTip) {
            this.toolTip = toolTip;
            return this;
        }

        public Builder leftAligned() {
            return this.withAlignment(ECAlignment.LEFT);
        }

        public Builder centerAligned() {
            return this.withAlignment(ECAlignment.CENTER);
        }

        public Builder rightAligned() {
            return this.withAlignment(ECAlignment.RIGHT);
        }

        public Builder withAlignment(ECAlignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public ECProgressBar complete() {
            return new ECProgressBar(this.x, this.y, this.width, this.label, this.value, this.filledColor, this.emptyColor, this.toolTip, this.alignment);
        }

        public static Builder start(int x, int y, int width) {
            return new Builder(x, y, width);
        }
    }
}

