/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public class ECTextBox
extends ECWidget {
    private final TextComponent titleComponent;
    private final Predicate<String> filter;
    private final Integer maximumLength;
    private String currentValue;
    private MultiLineLabel text;
    private boolean filterFailing = false;

    private ECTextBox(int x, int y, int width, int height, String label, String defaultText, Predicate<String> filter, Integer maximumLength) {
        super(x, y, width, height);
        this.titleComponent = label != null ? ComponentUtil.buildColoredTextComponent(label) : null;
        this.currentValue = defaultText != null ? defaultText : "";
        this.filter = filter;
        this.maximumLength = maximumLength;
        this.updateTextBox();
    }

    public String getValue() {
        return this.currentValue;
    }

    private void updateTextBox() {
        this.text = MultiLineLabel.m_94341_((Font)this.getFont(), (FormattedText)ComponentUtil.buildColoredTextComponent(this.currentValue), (int)this.f_93618_);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        this.m_93692_(true);
        return true;
    }

    public boolean m_7933_(int keyPressed, int val, int shift) {
        if (this.m_93696_() && keyPressed == 259 && !this.currentValue.isEmpty()) {
            this.currentValue = this.currentValue.substring(0, this.currentValue.length() - 1);
            this.updateTextBox();
            this.updateFailFilterState();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char typed, int shift) {
        if (this.m_93696_() && !this.isAtMaximumLength()) {
            this.currentValue = this.currentValue + typed;
            this.updateTextBox();
            this.updateFailFilterState();
            return true;
        }
        return false;
    }

    private boolean isAtMaximumLength() {
        return this.maximumLength != null && this.currentValue.length() >= this.maximumLength;
    }

    private void updateFailFilterState() {
        if (this.filter == null) {
            this.filterFailing = false;
            return;
        }
        this.filterFailing = this.filter.test(this.currentValue);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int y = 0;
        if (this.titleComponent != null) {
            ECTextBox.m_93243_((PoseStack)poseStack, (Font)this.getFont(), (Component)this.titleComponent, (int)this.dx(0), (int)this.dy(y), (int)GuiConstants.COLOR_WHITE);
            y += 15;
        }
        this.text.m_6516_(poseStack, this.dx(0), this.dy(y), GuiUtil.getSpacedLineHeight(), this.filterFailing ? GuiConstants.COLOR_WHITE : GuiConstants.COLOR_RED);
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private String label;
        private String defaultText;
        private Predicate<String> filter;
        private Integer maximumLength;

        private Builder(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withDefaultText(String defaultText) {
            this.defaultText = defaultText;
            return this;
        }

        public Builder withFilter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder withMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public ECTextBox complete() {
            return new ECTextBox(this.x, this.y, this.width, this.height, this.label, this.defaultText, this.filter, this.maximumLength);
        }

        public static Builder start(int x, int y, int width, int height) {
            return new Builder(x, y, width, height);
        }
    }
}

