/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ECTextField
extends ECWidget {
    private final TextComponent labelComponent;
    private final EditBox entryBox;
    private final Consumer<String> onUpdate;

    private ECTextField(int x, int y, int width, String label, String defaultValue, Integer maximumLength, Predicate<String> filter, Consumer<String> onUpdate) {
        super(x, y, width, 15);
        this.labelComponent = label != null ? ComponentUtil.buildColoredTextComponent(label) : null;
        int labelWidth = label != null ? this.getFont().m_92895_(label) : 0;
        this.entryBox = new EditBox(this.getFont(), this.dx(labelWidth + 2), this.dy(0), width - labelWidth, this.f_93619_, (Component)ComponentUtil.buildColoredTextComponent(label != null ? label : ""));
        if (filter != null) {
            this.entryBox.m_94153_(filter);
        }
        if (defaultValue != null) {
            this.entryBox.m_94144_(defaultValue);
        }
        if (maximumLength != null) {
            this.entryBox.m_94199_(maximumLength.intValue());
        }
        this.onUpdate = onUpdate;
    }

    public String getValue() {
        return this.entryBox.m_94155_();
    }

    public void setError(boolean error) {
        this.entryBox.m_94202_(error ? Argb.ARGB_RED.getIntValue() : Argb.ARGB_WHITE.getIntValue());
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.labelComponent != null) {
            ECTextField.m_93243_((PoseStack)poseStack, (Font)this.getFont(), (Component)this.labelComponent, (int)this.dx(0), (int)(this.dy(0) + 2), (int)GuiConstants.COLOR_GRAY);
        }
        this.entryBox.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.entryBox.m_5953_(mouseX, mouseY)) {
            this.m_93692_(true);
            return true;
        }
        this.m_93692_(false);
        return false;
    }

    public boolean m_7933_(int keyPressed, int val2, int shift) {
        if (this.isTextBoxFocused()) {
            boolean res = this.entryBox.m_7933_(keyPressed, val2, shift);
            if (res) {
                this.fireOnUpdate();
            }
            return res;
        }
        return false;
    }

    public boolean m_5534_(char typed, int shift) {
        if (this.isTextBoxFocused()) {
            boolean res = this.entryBox.m_5534_(typed, shift);
            if (res) {
                this.fireOnUpdate();
            }
            return res;
        }
        return false;
    }

    private void fireOnUpdate() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this.getValue());
        }
    }

    public boolean isTextBoxFocused() {
        return this.entryBox.m_93696_();
    }

    public void m_93692_(boolean focus) {
        super.m_93692_(focus);
        this.entryBox.m_94178_(focus);
    }

    public void setValue(String value) {
        this.entryBox.m_94144_(value);
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private String label;
        private String defaultValue = null;
        private Integer maximumLength = null;
        private Predicate<String> filter = null;
        private Consumer<String> onUpdate = null;

        private Builder(int x, int y, int width) {
            this.x = x;
            this.y = y;
            this.width = width;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withMaximumLength(int maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public Builder withFilter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder withOnUpdate(Consumer<String> onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        public ECTextField complete() {
            return new ECTextField(this.x, this.y, this.width, this.label, this.defaultValue, this.maximumLength, this.filter, this.onUpdate);
        }

        public static Builder start(int x, int y, int width) {
            return new Builder(x, y, width);
        }
    }
}

