/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECAlignment;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;

public class ECToggleButton
extends ECWidget {
    private final ECField textField;
    private final Argb buttonColor;
    private final boolean disabled;
    private final ResourceLocation icon;
    private final int iconWidth;
    private final int iconHeight;
    private boolean selected;

    public ECToggleButton(int x, int y, int width, int height, String label) {
        this(x, y, width, height, label, Argb.ARGB_AQUA, Argb.ARGB_WHITE, false, ECAlignment.LEFT, null, 0, 0, false);
    }

    public ECToggleButton(int x, int y, int width, int height, String label, boolean selected) {
        this(x, y, width, height, label, Argb.ARGB_AQUA, Argb.ARGB_WHITE, false, ECAlignment.LEFT, null, 0, 0, selected);
    }

    private ECToggleButton(int x, int y, int width, int height, String label, Argb labelColor, Argb buttonColor, boolean disabled, ECAlignment alignment, ResourceLocation icon, int iconWidth, int iconHeight, boolean selected) {
        super(x, y, width, height);
        this.buttonColor = buttonColor;
        this.disabled = disabled;
        this.icon = icon;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.f_93620_ = this.determineXForAlignment(x, width, alignment);
        ECField.Builder textFieldBuilder = ECField.Builder.start(this.dx(width / 2), this.dy(height / 2 - GuiUtil.getSpacedLineHeight() / 2), width - 10).withValue(label).withValueColor(disabled ? Argb.ARGB_MC_GRAY : labelColor).centerAligned();
        this.textField = textFieldBuilder.complete();
        this.selected = selected;
    }

    private int determineXForAlignment(int x, int width, ECAlignment alignment) {
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case ECAlignment.LEFT -> x;
            case ECAlignment.CENTER -> x - width / 2;
            case ECAlignment.RIGHT -> x - width;
        };
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (!this.disabled) {
            this.selected = !this.selected;
        }
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, this.determineColor());
        this.textField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.icon != null) {
            int width = this.iconWidth != 0 ? this.iconWidth : GuiUtil.getSpacedLineHeight();
            int height = this.iconHeight != 0 ? this.iconHeight : GuiUtil.getSpacedLineHeight();
            GuiUtil.drawImage(poseStack, this.icon, this.dx(0), this.dy(0), width, height);
        }
    }

    private Argb determineColor() {
        if (this.selected) {
            return this.buttonColor.withTransparency(100);
        }
        return this.buttonColor.withTransparency(30);
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private String label;
        private Argb labelColor = Argb.ARGB_AQUA;
        private Argb buttonColor = Argb.ARGB_WHITE;
        private boolean disabled = false;
        private ECAlignment alignment = ECAlignment.LEFT;
        private ResourceLocation icon = null;
        private int iconWidth = 0;
        private int iconHeight = 0;
        private boolean selected = false;

        private Builder(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withLabelColor(Argb labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder withButtonColor(Argb buttonColor) {
            this.buttonColor = buttonColor;
            return this;
        }

        public Builder withDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder withSelected(boolean selected) {
            this.selected = selected;
            return this;
        }

        public Builder leftAligned() {
            return this.withAlignment(ECAlignment.LEFT);
        }

        public Builder centerAligned() {
            return this.withAlignment(ECAlignment.CENTER);
        }

        public Builder rightAligned() {
            return this.withAlignment(ECAlignment.RIGHT);
        }

        public Builder withAlignment(ECAlignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder withIcon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder withIcon(ResourceLocation icon, int width, int height) {
            this.icon = icon;
            this.iconWidth = width;
            this.iconHeight = height;
            return this;
        }

        public ECToggleButton complete() {
            return new ECToggleButton(this.x, this.y, this.width, this.height, this.label, this.labelColor, this.buttonColor, this.disabled, this.alignment, this.icon, this.iconWidth, this.iconHeight, this.selected);
        }

        public static Builder start(int x, int y, int width, int height) {
            return new Builder(x, y, width, height);
        }
    }
}

