/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.components;

import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.client.gui.components.ScrollableListItem;
import com.equestricraft.mod.client.gui.components.SliderButton;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScrollableList
extends ECWidget {
    private List<SliderButton> options;
    private final int maximumSelection;
    private int scroll = 0;
    private TextComponent tooltip = null;
    private final List<Consumer<List<Integer>>> selectionChangeListeners = new ArrayList<Consumer<List<Integer>>>();

    public ScrollableList(int x, int y, int width, int height, List<ScrollableListItem> items, int maximumSelection) {
        super(x, y, width, height);
        this.options = items.stream().sorted(Comparator.comparing(ScrollableListItem::getItemName)).map(i -> new SliderButton(0, y, height, i.getItemId(), i.getItemName(), i.getDescription())).toList();
        this.maximumSelection = maximumSelection;
    }

    public void setOptions(List<ScrollableListItem> items) {
        List<Integer> selected = this.getSelected();
        this.options = items.stream().sorted(Comparator.comparing(ScrollableListItem::getItemName)).map(i -> new SliderButton(0, this.f_93621_, this.f_93619_, i.getItemId(), i.getItemName(), i.getDescription())).toList();
        for (SliderButton option : this.options) {
            option.setSelected(selected.contains(option.getID()));
            if (this.getSelectedCount() >= this.maximumSelection) {
                option.setDisabled(!option.isSelected());
                continue;
            }
            option.setDisabled(false);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        AtomicInteger i = new AtomicInteger(0);
        this.tooltip = null;
        this.options.forEach(option -> {
            if (option.getTooltip() != null && option.m_5953_(mouseX, mouseY)) {
                this.tooltip = ComponentUtil.buildColoredTextComponent(option.getTooltip());
            }
            option.f_93620_ = this.dx(i.getAndAdd(option.m_5711_() + 5) + this.scroll);
            if (this.getSelectedCount() >= this.maximumSelection) {
                option.setDisabled(!option.isSelected());
            } else {
                option.setDisabled(false);
            }
            option.m_6305_(poseStack, mouseX, mouseY, partialTick);
        });
    }

    public TextComponent getTooltip() {
        return this.tooltip;
    }

    public List<Integer> getSelected() {
        return this.options.stream().filter(SliderButton::isSelected).map(SliderButton::getID).toList();
    }

    public void setSelected(List<Integer> values2) {
        for (SliderButton option : this.options) {
            option.setSelected(values2.contains(option.getID()));
        }
    }

    private int getSelectedCount() {
        return (int)this.options.stream().filter(SliderButton::isSelected).count();
    }

    public void onSelectionChanged(Consumer<List<Integer>> listener) {
        this.selectionChangeListeners.add(listener);
    }

    private void fireSelectionChange() {
        List<Integer> selection = this.getSelected();
        this.selectionChangeListeners.forEach(listener -> listener.accept(selection));
    }

    @Override
    public boolean m_6050_(double x, double y, double scroll) {
        this.scroll = (int)((double)this.scroll + scroll * 6.0);
        return false;
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int button) {
        int selected = this.getSelectedCount();
        for (SliderButton option : this.options) {
            if (!option.isSelected() && selected >= this.maximumSelection || !option.m_6375_(mouseX, mouseY, button)) continue;
            this.fireSelectionChange();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char typed, int shift) {
        AtomicInteger offset = new AtomicInteger(0);
        AtomicBoolean success = new AtomicBoolean(false);
        this.options.forEach(option -> {
            if (!success.get()) {
                String message = option.getLabel();
                if (message.toLowerCase().charAt(0) == String.valueOf(typed).toLowerCase().charAt(0)) {
                    this.scroll = -offset.get();
                    success.set(true);
                }
                offset.addAndGet(Mth.m_14143_((float)Minecraft.m_91087_().f_91062_.m_92865_().m_92353_(message)) + this.f_93619_ - 4);
            }
        });
        return success.get();
    }
}

