/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.faction;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.faction.PlayerFactionInformation;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FactionMenuScreen
extends Screen {
    private final PlayerFactionInformation playerFactionInformation;
    private ECMultiLineField descriptionLabel = null;
    private TextComponent rankNameComponent = null;
    private int rankNameY = 0;
    private ECMultiLineField rankDescriptionLabel = null;
    private static final int X_MARGIN = 10;

    public static void showScreen(PlayerFactionInformation playerFactionInformation) {
        FactionMenuScreen screen = new FactionMenuScreen(playerFactionInformation);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private FactionMenuScreen(PlayerFactionInformation playerFactionInformation) {
        super((Component)ComponentUtil.buildColoredTextComponent(playerFactionInformation.factionName()));
        this.playerFactionInformation = playerFactionInformation;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(this.playerFactionInformation.factionDescription()).withWidth(this.f_96543_ - 12).withPosition(10, 35).complete();
        this.rankNameComponent = ComponentUtil.buildColoredTextComponent(this.playerFactionInformation.rankName());
        this.rankNameY = this.descriptionLabel.getHeight() + 45;
        this.rankDescriptionLabel = ECMultiLineField.Builder.start().withLabel(this.playerFactionInformation.factionDescription()).withPosition(10, this.descriptionLabel.getHeight() + 60).withWidth(this.f_96543_ - 20).complete();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        FactionMenuScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)10, (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        GuiUtil.drawHorizontalLine(poseStack, 10, this.f_96543_ - 10, 25, 2, this.playerFactionInformation.color());
        this.descriptionLabel.render(poseStack);
        FactionMenuScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.rankNameComponent, (int)10, (int)this.rankNameY, (int)Argb.ARGB_WHITE.getIntValue());
        this.rankDescriptionLabel.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

