/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseCertificatesInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseViewMenuInteractPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseCertificatesScreen
extends Screen {
    private final HorseSimple horse;
    private final HorseCertificatesInfo info;

    public static void showScreen(HorseSimple horse, HorseCertificatesInfo info2) {
        HorseCertificatesScreen screen = new HorseCertificatesScreen(horse, info2);
        ScreenStack.getInstance().push(screen);
    }

    private HorseCertificatesScreen(HorseSimple horse, HorseCertificatesInfo info2) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-certificates-menu.title", horse.name())));
        this.horse = horse;
        this.info = info2;
    }

    protected void m_7856_() {
        ECButton breedCertificateButton;
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        int buttonX = this.f_96543_ / 2;
        int currentY = 25;
        if (this.info.hasBreedCertificate()) {
            breedCertificateButton = ECButton.Builder.start(buttonX, currentY, 120, 20).withLabel(I18n.getLabel("horse-certificates-menu.button.breed-certificate.label")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horse.id(), "BREEDS"))).centerAligned().complete();
            this.m_142416_((GuiEventListener)breedCertificateButton);
            currentY += 25;
        }
        if (this.info.hasRegistrationCertificate()) {
            breedCertificateButton = ECButton.Builder.start(buttonX, currentY, 120, 20).withLabel(I18n.getLabel("horse-certificates-menu.button.registration-certificate.label")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horse.id(), "REGISTRATION_CERTIFICATE"))).centerAligned().complete();
            this.m_142416_((GuiEventListener)breedCertificateButton);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseCertificatesScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

