/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.Argb;
import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.information.HorseDetailsInformation;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.horse.weight.WeightStatus;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECProgressBar;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseViewMenuInteractPacket;
import com.equestricraft.mod.packet.ServerBoundSetHorseCurrentValueRequestPacket;
import com.equestricraft.mod.packet.ServerBoundSetHorseNameRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseDetailsScreen
extends Screen {
    private final int horseId;
    private final HorseDetailsInformation data;
    private final List<ECField> fields = new ArrayList<ECField>(0);
    private ECMultiLineField coatDescription;
    private ResourceLocation weightSymbol = null;
    private int weightSymbolX;
    private int weightSymbolY;

    public static void showMenu(int horseId, HorseDetailsInformation data) {
        HorseDetailsScreen prompt = new HorseDetailsScreen(horseId, data);
        ScreenStack.getInstance().push(prompt);
    }

    public HorseDetailsScreen(int horseId, HorseDetailsInformation data) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.details.title")));
        this.horseId = horseId;
        this.data = data;
    }

    private void moveLocation(AtomicInteger currentY) {
        currentY.addAndGet(GuiUtil.getSpacedLineHeight());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.createFields();
        this.createButtons();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
    }

    private void createFields() {
        int currentX = 10;
        AtomicInteger currentY = new AtomicInteger(35);
        if (this.data.playerAccessLevel().isAtLeast(HorsePermissionLevel.BASIC)) {
            ECField nameField = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.name.label")).withValue(this.data.name()).complete();
            this.m_142416_((GuiEventListener)nameField);
            if (this.data.playerAccessLevel().isAtLeast(HorsePermissionLevel.OWNER)) {
                ECButton editNameButton = ECButton.Builder.start(currentX + nameField.m_5711_() + 5, currentY.get(), 35, nameField.m_93694_() - 2).withLabel(I18n.getLabel("common.edit")).withOnClick(this::onNameEditClick).complete();
                this.m_142416_((GuiEventListener)editNameButton);
            }
            this.moveLocation(currentY);
        }
        if (this.data.owner() != null) {
            ECField ownerComponent = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.owner.label")).withValue(this.data.owner().ign()).complete();
            this.m_142416_((GuiEventListener)ownerComponent);
            this.moveLocation(currentY);
        }
        ECField showNameComponent = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.show-name.label")).withValue(this.data.showName() != null ? this.data.showName() : I18n.getLabel("horse-information-menu.details.field.show-name.none")).complete();
        this.m_142416_((GuiEventListener)showNameComponent);
        this.moveLocation(currentY);
        if (this.data.weight() != null) {
            ECField weightComponent = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.weight.label")).withValue(I18n.getLabel("horse-information-menu.details.field.weight.value", this.data.weight().currentWeight(), DateFormatter.formatDateDateMonthYear(this.data.weight().lastTime()))).withToolTip(this.data.weight().status().getTranslatedName()).complete();
            this.m_142416_((GuiEventListener)weightComponent);
            if (this.data.weight().status() == WeightStatus.OVERWEIGHT) {
                this.weightSymbol = Resources.getTextures().getGui().get("horse_overweight.png");
            } else if (this.data.weight().status() == WeightStatus.UNDERWEIGHT) {
                this.weightSymbol = Resources.getTextures().getGui().get("horse_underweight.png");
            }
            this.weightSymbolX = currentX + weightComponent.m_5711_() + 5;
            this.weightSymbolY = currentY.get() - 2;
            this.moveLocation(currentY);
        }
        ECField heightComponent = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.height.label")).withValue(I18n.getLabel("horse-information-menu.details.field.height.value", this.data.height())).complete();
        this.m_142416_((GuiEventListener)heightComponent);
        this.moveLocation(currentY);
        ECField trustComponent = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.trust.label")).withValue(this.data.trustLevel()).withToolTip(I18n.getLabel("horse-information-menu.details.field.trust.tooltip")).complete();
        this.m_142416_((GuiEventListener)trustComponent);
        this.moveLocation(currentY);
        ECField breedComponent = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.breed.label")).withValue(this.data.breed()).complete();
        this.m_142416_((GuiEventListener)breedComponent);
        this.moveLocation(currentY);
        ECField currentValueLabel = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.current-value.label")).withValue(this.data.currentValue()).complete();
        this.m_142416_((GuiEventListener)currentValueLabel);
        if (this.data.playerAccessLevel().isAtLeast(HorsePermissionLevel.OWNER)) {
            ECButton editValueButton = ECButton.Builder.start(currentX + currentValueLabel.m_5711_() + 5, currentY.get(), 35, currentValueLabel.m_93694_() - 2).withLabel(I18n.getLabel("common.edit")).withOnClick(this::onValueEditClick).complete();
            this.m_142416_((GuiEventListener)editValueButton);
        }
        this.moveLocation(currentY);
        ECField microchippedField = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.microchipped")).withValue(this.data.microchipped() ? I18n.getLabel("common.yes") : I18n.getLabel("common.no")).complete();
        this.m_142416_((GuiEventListener)microchippedField);
        this.moveLocation(currentY);
        if (this.data.shoeInformation() != null) {
            ECField shoeField = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.shoe")).withValue(this.data.shoeInformation().name()).withToolTip(this.data.shoeInformation().conditionPercentage() + "%").withValueColor(this.data.shoeInformation().conditionPercentage() > 10.0 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)shoeField);
            ECProgressBar shoePercentage = ECProgressBar.Builder.start(currentX + shoeField.m_5711_() + 10, currentY.get(), 50).withValue((int)this.data.shoeInformation().conditionPercentage()).withFilledColor(this.data.shoeInformation().conditionPercentage() > 30.0 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)shoePercentage);
            if (this.data.shoeInformation().shoeMissing()) {
                ECField shoeMissingLabel = ECField.Builder.start(currentX + shoeField.m_5711_() + 70, currentY.get(), 50).withValue(I18n.getLabel("horse-information-menu.details.field.shoe.missing")).complete();
                this.m_142416_((GuiEventListener)shoeMissingLabel);
            }
            this.moveLocation(currentY);
        }
        if (this.data.bitInformation() != null) {
            ECField bitField = ECField.Builder.start(currentX, currentY.get(), this.f_96543_ / 2).withLabel(I18n.getLabel("horse-information-menu.details.field.bit")).withValue(this.data.bitInformation().name()).withToolTip(this.data.bitInformation().conditionPercentage() + "%").withValueColor(this.data.bitInformation().conditionPercentage() > 10.0 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)bitField);
            ECProgressBar bitPercentage = ECProgressBar.Builder.start(currentX + bitField.m_5711_() + 10, currentY.get(), 50).withValue((int)this.data.bitInformation().conditionPercentage()).withFilledColor(this.data.bitInformation().conditionPercentage() > 30.0 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)bitPercentage);
            this.moveLocation(currentY);
        }
        this.coatDescription = ECMultiLineField.Builder.start().withLabel(this.data.coatDescription()).withPosition(currentX, currentY.get()).withWidth(this.f_96543_ - 10).complete();
        currentY.addAndGet(this.coatDescription.getHeight());
    }

    private void onNameEditClick() {
        ServerBoundSetHorseNameRequestPacket packet = new ServerBoundSetHorseNameRequestPacket(this.horseId, "DETAILS");
        Network.sendToServer(packet);
    }

    private void onValueEditClick() {
        ServerBoundSetHorseCurrentValueRequestPacket packet = new ServerBoundSetHorseCurrentValueRequestPacket(this.horseId, "DETAILS");
        Network.sendToServer(packet);
    }

    private void createButtons() {
        ECButton weightLogButton = ECButton.Builder.start(10, this.f_96544_ - 30, 120, 20).withLabel(I18n.getLabel("horse-information-menu.details.button.weight-log.label")).withIcon(Resources.getTextures().getGui().get("weight_icon.png"), 20, 20).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "WEIGHT_LOG"))).complete();
        this.m_142416_((GuiEventListener)weightLogButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseDetailsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        for (ECField field : this.fields) {
            if (field.getToolTip() == null || !field.m_5953_(mouseX, mouseY)) continue;
            this.m_96602_(poseStack, (Component)field.getToolTip(), mouseX, mouseY);
        }
        if (this.weightSymbol != null) {
            GuiUtil.drawImage(poseStack, this.weightSymbol, this.weightSymbolX, this.weightSymbolY, GuiUtil.getStandardLineHeight() * 2, GuiUtil.getStandardLineHeight());
        }
        this.coatDescription.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

