/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.instruction.HorseInstructionInfo;
import com.equestricraft.core.horse.instruction.HorseInstructionState;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseInstructionGivePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseInstructionMenuScreen
extends Screen {
    private final UUID entityUuid;
    private final List<HorseInstructionInfo> instructions;

    public static void showScreen(UUID entityUuid, List<HorseInstructionInfo> instructions) {
        HorseInstructionMenuScreen screen = new HorseInstructionMenuScreen(entityUuid, instructions);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private HorseInstructionMenuScreen(UUID entityUuid, List<HorseInstructionInfo> instructions) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.instruction-give.menu.title")));
        this.entityUuid = entityUuid;
        this.instructions = instructions;
    }

    protected void m_7856_() {
        super.m_7856_();
        int y = 25;
        for (HorseInstructionInfo instruction : this.instructions) {
            int labelWidth = this.f_96547_.m_92895_(instruction.label()) + 10;
            ECButton button = ECButton.Builder.start(this.f_96543_ / 2, y, labelWidth, 20).withLabel(instruction.label()).withOnClick(() -> this.sendAction(instruction.type(), instruction.state() == HorseInstructionState.INACTIVE)).centerAligned().complete();
            this.m_142416_((GuiEventListener)button);
            y += button.m_93694_() + 5;
        }
    }

    private void sendAction(HorseInstructionType instructionType, boolean action) {
        this.m_7379_();
        ServerBoundHorseInstructionGivePacket packet = new ServerBoundHorseInstructionGivePacket(this.entityUuid, instructionType, action);
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseInstructionMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

