/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.horse.interact.HorseInteractAction;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseInteractMenuSelectPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseInteractMenuScreen
extends Screen {
    private final UUID entityUuid;

    public static void showScreen(UUID entityUuid) {
        HorseInteractMenuScreen screen = new HorseInteractMenuScreen(entityUuid);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private HorseInteractMenuScreen(UUID entityUuid) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.interact-menu.title")));
        this.entityUuid = entityUuid;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.buildButton(30, HorseInteractAction.MOUNT));
        this.m_142416_((GuiEventListener)this.buildButton(60, HorseInteractAction.TAP_NOSE));
        this.m_142416_((GuiEventListener)this.buildButton(90, HorseInteractAction.SCRATCH));
        this.m_142416_((GuiEventListener)this.buildButton(120, HorseInteractAction.TACK));
    }

    private ECButton buildButton(int y, HorseInteractAction action) {
        String label = action.getTranslatedName();
        int labelWidth = this.f_96547_.m_92895_(label) + 10;
        return ECButton.Builder.start(this.f_96543_ / 2, y, labelWidth, 20).withLabel(label).withOnClick(() -> this.sendAction(action)).centerAligned().complete();
    }

    private void sendAction(HorseInteractAction action) {
        this.m_7379_();
        ServerBoundHorseInteractMenuSelectPacket packet = new ServerBoundHorseInteractMenuSelectPacket(this.entityUuid, action);
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseInteractMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

