/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.information.HorseBasicViewDetails;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseViewMenuInteractPacket;
import com.equestricraft.mod.packet.ServerBoundLineageMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundProgressionMenuOpenPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseMenuScreen
extends Screen {
    private final int horseId;
    private final HorseBasicViewDetails details;
    private ECField showNameField = null;
    private ECField ownerField = null;
    private ECField genderField = null;
    private ECField ageField = null;
    private ECField breedField = null;
    private ECField statusField = null;
    private ECField lastRideTimeField = null;
    private ECField pregnancyConfirmedField = null;
    private ECField stallRestField = null;
    private final ResourceLocation fileIcon = Resources.getTextures().getGui().get("file_icon.png");
    private final ResourceLocation keyIcon = Resources.getTextures().getGui().get("key_icon.png");
    private final ResourceLocation statsChartIcon = Resources.getTextures().getGui().get("stats_chart_icon.png");
    private final ResourceLocation disciplineIcon = Resources.getTextures().getGui().get("discipline_icon.png");
    private final ResourceLocation rulerIcon = Resources.getTextures().getGui().get("ruler_icon.png");
    private final ResourceLocation brainIcon = Resources.getTextures().getGui().get("brain_icon.png");
    private final ResourceLocation certificateIcon = Resources.getTextures().getGui().get("certificate_icon.png");
    private final ResourceLocation familyTreeIcon = Resources.getTextures().getGui().get("family_tree_icon.png");
    private final ResourceLocation heartIcon = Resources.getTextures().getGui().get("heart_icon.png");
    private final ResourceLocation saleHistoryIcon = Resources.getTextures().getGui().get("sale_history_icon.png");

    public static void showHorseMainMenu(int horseId, HorseBasicViewDetails horseName) {
        HorseMenuScreen prompt = new HorseMenuScreen(horseId, horseName);
        ScreenStack.getInstance().push(prompt);
    }

    public HorseMenuScreen(int horseId, HorseBasicViewDetails details) {
        super((Component)ComponentUtil.buildColoredTextComponent(details.name()));
        this.horseId = horseId;
        this.details = details;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECButton progressionButton = ECButton.Builder.start(this.f_96543_ - 10, 10, 120, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.progression.label")).withOnClick(() -> Network.sendToServer(new ServerBoundProgressionMenuOpenPacket(this.horseId))).rightAligned().complete();
        int y = 20;
        this.breedField = ECField.Builder.start(this.f_96543_ / 3 * 2 - 5, y, this.f_96543_).withValue(this.details.breed()).withValueColor(Argb.ARGB_WHITE).rightAligned().complete();
        this.statusField = ECField.Builder.start(this.f_96543_ / 3 * 2 - 5, y + GuiUtil.getSpacedLineHeight(), this.f_96543_).withValue(this.details.status()).withValueColor(Argb.ARGB_WHITE).rightAligned().complete();
        this.m_142416_((GuiEventListener)progressionButton);
        if (this.details.owner() != null) {
            this.ownerField = ECField.Builder.start(5, y, this.f_96543_).withValue(this.details.owner()).withValueColor(Argb.ARGB_WHITE).complete();
            y += GuiUtil.getSpacedLineHeight();
        }
        if (this.details.showName() != null) {
            this.showNameField = ECField.Builder.start(5, y, this.f_96543_).withValue(this.details.showName()).withValueColor(Argb.ARGB_WHITE).complete();
            y += GuiUtil.getSpacedLineHeight();
        }
        this.genderField = ECField.Builder.start(5, y, this.f_96543_).withValue(this.details.gender()).withValueColor(Argb.ARGB_WHITE).complete();
        this.ageField = ECField.Builder.start(5, y += GuiUtil.getSpacedLineHeight(), this.f_96543_).withValue(this.details.age()).withValueColor(Argb.ARGB_WHITE).complete();
        if (this.details.pregnancyConfirmed()) {
            this.pregnancyConfirmedField = ECField.Builder.start(this.f_96543_ / 3 * 2 - 5, y, this.f_96543_).withValue(I18n.getLabel("horse-information-menu.main.field.pregnant")).withValueColor(Argb.ARGB_GREEN).rightAligned().complete();
        }
        y += GuiUtil.getSpacedLineHeight();
        if (this.details.lastRideTime() != null) {
            this.lastRideTimeField = ECField.Builder.start(5, y, this.f_96543_).withLabel(I18n.getLabel("horse-information-menu.main.field.last-ride-time.label")).withValue(this.details.lastRideTime()).complete();
        }
        y += GuiUtil.getSpacedLineHeight();
        if (this.details.stallRest()) {
            this.stallRestField = ECField.Builder.start(5, y, this.f_96543_).withLabel(I18n.getLabel("horse-information-menu.main.field.stall-rest.label")).complete();
        }
        int buttonWidth = this.f_96543_ / 2 - 15;
        int buttonHeight = 20;
        int xColumnOne = 10;
        int xColumnTwo = this.f_96543_ / 2 + 5;
        int buttonSize = 20;
        ECButton detailsButton = ECButton.Builder.start(10, 110, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.details")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "DETAILS"))).withIcon(this.fileIcon, 20, 20).complete();
        ECButton welfareButton = ECButton.Builder.start(xColumnTwo, 110, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.welfare")).withButtonColor(this.colorForHealth(this.details.health())).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "HEALTH"))).withIcon(this.heartIcon, 20, 20).complete();
        ECButton accessButton = ECButton.Builder.start(10, 135, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.access")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "PLAYER_ACCESS"))).withIcon(this.keyIcon, 20, 20).complete();
        ECButton statsButton = ECButton.Builder.start(xColumnTwo, 135, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.stats")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "STATS"))).withIcon(this.statsChartIcon, 20, 20).complete();
        ECButton disciplinesButton = ECButton.Builder.start(10, 160, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.disciplines")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "DISCIPLINES"))).withDisabled(!this.details.disciplinesCertified()).withIcon(this.disciplineIcon, 20, 20).complete();
        ECButton conformationButton = ECButton.Builder.start(xColumnTwo, 160, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.conformation")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "CONFORMATION"))).withIcon(this.rulerIcon, 20, 20).complete();
        ECButton skillsButton = ECButton.Builder.start(10, 185, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.skills")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "SKILLS"))).withIcon(this.brainIcon, 20, 20).complete();
        ECButton familyTreeButton = ECButton.Builder.start(xColumnTwo, 185, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.view-parents")).withOnClick(() -> Network.sendToServer(new ServerBoundLineageMenuOpenPacket(this.horseId))).withDisabled(!this.details.hasParents()).withIcon(this.familyTreeIcon, 20, 20).complete();
        ECButton saleHistoryButton = ECButton.Builder.start(10, 210, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.sale-history")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "SALE_HISTORY"))).withIcon(this.saleHistoryIcon, 20, 20).complete();
        ECButton certificatesButton = ECButton.Builder.start(xColumnTwo, 210, buttonWidth, 20).withLabel(I18n.getLabel("horse-information-menu.main.button.view-certificates")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horseId, "CERTIFICATES"))).withIcon(this.certificateIcon, 20, 20).complete();
        this.m_142416_((GuiEventListener)detailsButton);
        this.m_142416_((GuiEventListener)welfareButton);
        this.m_142416_((GuiEventListener)accessButton);
        this.m_142416_((GuiEventListener)statsButton);
        this.m_142416_((GuiEventListener)disciplinesButton);
        this.m_142416_((GuiEventListener)conformationButton);
        this.m_142416_((GuiEventListener)skillsButton);
        this.m_142416_((GuiEventListener)familyTreeButton);
        this.m_142416_((GuiEventListener)saleHistoryButton);
        this.m_142416_((GuiEventListener)certificatesButton);
    }

    private Argb colorForHealth(HorseHealth health) {
        return switch (health) {
            default -> throw new IncompatibleClassChangeError();
            case HorseHealth.GREEN -> Argb.ARGB_GREEN;
            case HorseHealth.AMBER -> Argb.ARGB_YELLOW;
            case HorseHealth.RED -> Argb.ARGB_RED;
        };
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        HorseMenuScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)5, (int)5, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        if (this.showNameField != null) {
            this.showNameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.ownerField != null) {
            this.ownerField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.breedField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.statusField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.genderField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.ageField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.lastRideTimeField != null) {
            this.lastRideTimeField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.pregnancyConfirmedField != null) {
            this.pregnancyConfirmedField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.stallRestField != null) {
            this.stallRestField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        poseStack.m_85849_();
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

