/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseParentalViewInformation;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseParentScreen
extends Screen {
    private final HorseParentalViewInformation parentalInformation;
    private TextComponent mother = null;
    private TextComponent motherName = null;
    private TextComponent motherShowName = null;
    private TextComponent motherOwner = null;
    private TextComponent motherAlive = null;
    private TextComponent father = null;
    private TextComponent fatherName = null;
    private TextComponent fatherShowName = null;
    private TextComponent fatherOwner = null;
    private TextComponent fatherAlive = null;

    public static void showHorseParentsMenu(HorseSimple horse, HorseParentalViewInformation parentalInformation) {
        HorseParentScreen prompt = new HorseParentScreen(horse, parentalInformation);
        ScreenStack.getInstance().push(prompt);
    }

    private HorseParentScreen(HorseSimple horse, HorseParentalViewInformation parentalInformation) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.title", horse.name())));
        this.parentalInformation = parentalInformation;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.mother = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.mother"));
        this.motherName = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.name", this.parentalInformation.mother().name()));
        if (this.parentalInformation.mother().showName() != null) {
            this.motherShowName = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.show-name", this.parentalInformation.mother().showName()));
        }
        this.motherOwner = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.owner", this.parentalInformation.mother().owner().ign()));
        this.motherAlive = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.alive", Boolean.TRUE.equals(this.parentalInformation.mother().alive()) ? I18n.getLabel("common.yes") : I18n.getLabel("common.no")));
        this.father = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.father"));
        this.fatherName = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.name", this.parentalInformation.father().name()));
        if (this.parentalInformation.father().showName() != null) {
            this.fatherShowName = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.show-name", this.parentalInformation.father().showName()));
        }
        this.fatherOwner = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.owner", this.parentalInformation.father().owner().ign()));
        this.fatherAlive = ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.parents.field.alive", Boolean.TRUE.equals(this.parentalInformation.father().alive()) ? I18n.getLabel("common.yes") : I18n.getLabel("common.no")));
        this.m_142416_((GuiEventListener)new BackButton(20, this.f_96544_ - 30));
    }

    public void m_6305_(PoseStack poseStack, int val1, int val2, float val3) {
        this.m_7333_(poseStack);
        HorseParentScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        AtomicInteger currentY = new AtomicInteger(20);
        int motherX = this.f_96543_ / 2 - 50;
        this.addComponent(this.mother, poseStack, motherX, currentY);
        this.addComponent(this.motherName, poseStack, motherX, currentY);
        if (this.motherShowName != null) {
            this.addComponent(this.motherShowName, poseStack, motherX, currentY);
        }
        this.addComponent(this.motherOwner, poseStack, motherX, currentY);
        this.addComponent(this.motherAlive, poseStack, motherX, currentY);
        currentY.set(20);
        int fatherX = this.f_96543_ / 2 + 50;
        this.addComponent(this.father, poseStack, fatherX, currentY);
        this.addComponent(this.fatherName, poseStack, fatherX, currentY);
        if (this.fatherShowName != null) {
            this.addComponent(this.fatherShowName, poseStack, fatherX, currentY);
        }
        this.addComponent(this.fatherOwner, poseStack, fatherX, currentY);
        this.addComponent(this.fatherAlive, poseStack, fatherX, currentY);
        super.m_6305_(poseStack, val1, val2, val3);
    }

    private void addComponent(TextComponent component, PoseStack poseStack, int x, AtomicInteger y) {
        HorseParentScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)component, (int)x, (int)y.addAndGet(15), (int)GuiConstants.COLOR_WHITE);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

