/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.registration.HorseRegistrationCertificateDetails;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class HorseRegistrationCertificateScreen
extends Screen {
    private final HorseRegistrationCertificateDetails details;
    private final ResourceLocation certificateSymbol = Resources.getTextures().getGui().get("certificate_symbol.png");
    private int scroll = 0;
    private int totalHeight = 0;
    private TextComponent organizationNameComponent = null;
    private TextComponent horseShowNameComponent = null;
    private final String registrationNumberLabel = I18n.getLabel("horse.registration-certificate.menu.field.registration-number.label");
    private final String currentOwnerLabel = I18n.getLabel("horse.registration-certificate.menu.field.current-owner.label");
    private final String genderLabel = I18n.getLabel("horse.registration-certificate.menu.field.gender.label");
    private final String genderValueLabel;
    private final String dateOfBirthLabel = I18n.getLabel("horse.registration-certificate.menu.field.date-of-birth.label");
    private final String dateOfBirthValue;
    private final String registeredDateLabel = I18n.getLabel("horse.registration-certificate.menu.field.registration-date.label");
    private final String registeredDateValue;
    private final String registeredByLabel = I18n.getLabel("horse.registration-certificate.menu.field.registered-by.label");
    private final String breedLabel = I18n.getLabel("horse.registration-certificate.menu.field.breed.label");

    public static void showScreen(HorseRegistrationCertificateDetails details) {
        HorseRegistrationCertificateScreen screen = new HorseRegistrationCertificateScreen(details);
        ScreenStack.getInstance().push(screen);
    }

    private HorseRegistrationCertificateScreen(HorseRegistrationCertificateDetails details) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.registration-certificate.menu.title")));
        this.details = details;
        this.genderValueLabel = details.gender().getTranslatedName();
        this.dateOfBirthValue = DateFormatter.formatDateFull(details.dateOfBirth());
        this.registeredDateValue = DateFormatter.formatDateFull(details.registrationDate());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.organizationNameComponent = ComponentUtil.buildColoredTextComponent(this.details.organization().name());
        this.horseShowNameComponent = ComponentUtil.buildColoredTextComponent(this.details.showName());
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseRegistrationCertificateScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        GuiUtil.drawImage(poseStack, this.certificateSymbol, 20, 10 + this.scroll, 30, 30);
        int y = 30;
        HorseRegistrationCertificateScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.organizationNameComponent, (int)(this.f_96543_ / 2), (int)(y + this.scroll), (int)GuiConstants.COLOR_WHITE);
        HorseRegistrationCertificateScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.horseShowNameComponent, (int)(this.f_96543_ / 2), (int)((y += GuiUtil.getSpacedLineHeight()) + this.scroll), (int)GuiConstants.COLOR_WHITE);
        ECField registrationNumberField = ECField.Builder.start(20, y += GuiUtil.getSpacedLineHeight() + GuiUtil.getSpacedLineHeight(), this.f_96543_ - 40).withLabel(this.registrationNumberLabel).withValue(this.details.registrationNumber()).complete();
        registrationNumberField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ECField currentOwnerField = ECField.Builder.start(20, y += registrationNumberField.m_93694_(), this.f_96543_ - 40).withLabel(this.currentOwnerLabel).withValue(this.details.currentOwner().ign()).complete();
        currentOwnerField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ECField genderField = ECField.Builder.start(20, y += currentOwnerField.m_93694_(), this.f_96543_ - 40).withLabel(this.genderLabel).withValue(this.genderValueLabel).complete();
        genderField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ECField dateOfBirthField = ECField.Builder.start(20, y += genderField.m_93694_(), this.f_96543_ - 40).withLabel(this.dateOfBirthLabel).withValue(this.dateOfBirthValue).complete();
        dateOfBirthField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ECField registeredDateField = ECField.Builder.start(20, y += dateOfBirthField.m_93694_(), this.f_96543_ - 40).withLabel(this.registeredDateLabel).withValue(this.registeredDateValue).complete();
        registeredDateField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ECField registeredByField = ECField.Builder.start(20, y += registeredDateField.m_93694_(), this.f_96543_ - 40).withLabel(this.registeredByLabel).withValue(this.details.registeredByPlayer().ign()).complete();
        registeredByField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ECField breedField = ECField.Builder.start(20, y += registeredByField.m_93694_(), this.f_96543_ - 40).withLabel(this.breedLabel).withValue(this.details.breed()).complete();
        breedField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.totalHeight = y += breedField.m_93694_();
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

