/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.sale.PreSaleInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseSellMenuResponse;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseSellMenuScreen
extends Screen {
    private final PreSaleInfo preSaleInfo;
    private ECButton confirmDetailsButton = null;
    private ECTextField nameBox = null;
    private ECButton purchaseButton = null;
    private ECButton cancelButton = null;
    private boolean confirmedDetails = false;

    public static void showScreen(PreSaleInfo preSaleInfo) {
        HorseSellMenuScreen screen = new HorseSellMenuScreen(preSaleInfo);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected HorseSellMenuScreen(PreSaleInfo preSaleInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.sell.menu.title", preSaleInfo.showName() != null ? preSaleInfo.showName() : I18n.getLabel("horse.sell.menu.no-show-name"))));
        this.preSaleInfo = preSaleInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = 10;
        int y = 25;
        ECField priceField = ECField.Builder.start(x, y, 50).withLabel(I18n.getLabel("horse.sell.menu.field.price.label")).withValue(this.preSaleInfo.value()).complete();
        this.m_142416_((GuiEventListener)priceField);
        y += GuiUtil.getSpacedLineHeight();
        if (this.preSaleInfo.pregnant()) {
            ECField pregnantField = ECField.Builder.start(x, y, 50).withLabel(I18n.getLabel("horse.sell.menu.field.pregnant.label")).complete();
            this.m_142416_((GuiEventListener)pregnantField);
            ECField foalOwnerField = ECField.Builder.start(x + 55, y, 50).withLabel(I18n.getLabel("horse.sell.menu.field.foal-owner.label")).withValue(this.preSaleInfo.foalOwner().ign()).complete();
            this.m_142416_((GuiEventListener)foalOwnerField);
            y += GuiUtil.getSpacedLineHeight();
        }
        ECField healthyField = ECField.Builder.start(x, y, 50).withLabel(I18n.getLabel("horse.sell.menu.field.health-status.label")).withValue(this.preSaleInfo.health().getTranslatedName()).complete();
        this.m_142416_((GuiEventListener)healthyField);
        ECField ageDisplay = ECField.Builder.start(x, y += GuiUtil.getSpacedLineHeight(), 50).withLabel(I18n.getLabel("horse.sell.menu.field.age.label")).withValue(this.preSaleInfo.ageDisplay()).complete();
        this.m_142416_((GuiEventListener)ageDisplay);
        ECField studRegistrationStatus = ECField.Builder.start(x, y += GuiUtil.getSpacedLineHeight(), 50).withLabel(I18n.getLabel("horse.sell.menu.field.stud-registration.label")).withValue(this.preSaleInfo.studRegistrationStatus().getTranslatedName()).complete();
        this.m_142416_((GuiEventListener)studRegistrationStatus);
        ECField sellingPlayerIgn = ECField.Builder.start(x, y += GuiUtil.getSpacedLineHeight(), 50).withLabel(I18n.getLabel("horse.sell.menu.field.selling-player.label")).withValue(this.preSaleInfo.sellingPlayer().ign()).complete();
        this.m_142416_((GuiEventListener)sellingPlayerIgn);
        ECField breedInfo = ECField.Builder.start(x, y += GuiUtil.getSpacedLineHeight(), 50).withLabel(I18n.getLabel("horse.sell.menu.field.breed.label")).withValue(this.preSaleInfo.breed()).complete();
        this.m_142416_((GuiEventListener)breedInfo);
        this.confirmDetailsButton = ECButton.Builder.start(this.f_96543_ / 2, y += GuiUtil.getSpacedLineHeight(), 100, 20).withLabel(I18n.getLabel("horse.sell.menu.button.confirm-details.label")).withOnClick(() -> {
            this.confirmedDetails = true;
        }).centerAligned().complete();
        this.nameBox = ECTextField.Builder.start(x, y, 210).withLabel(I18n.getLabel("horse.sell.menu.text-box.player-name.label")).complete();
        this.purchaseButton = ECButton.Builder.start(this.f_96543_ / 2, y += GuiUtil.getSpacedLineHeight() + 20, 100, 20).withLabel(I18n.getLabel("horse.sell.menu.button.purchase.label")).withOnClick(() -> {
            this.m_7379_();
            String name = this.nameBox.getValue();
            ServerBoundHorseSellMenuResponse packet = new ServerBoundHorseSellMenuResponse(this.preSaleInfo.horseId(), true, name);
            Network.sendToServer(packet);
        }).centerAligned().complete();
        this.cancelButton = ECButton.Builder.start(this.f_96543_ / 2, this.f_96544_ - 25, 100, 20).withLabel(I18n.getLabel("horse.sell.menu.button.cancel.label")).withOnClick(() -> {
            this.m_7379_();
            ServerBoundHorseSellMenuResponse packet = new ServerBoundHorseSellMenuResponse(this.preSaleInfo.horseId(), false, null);
            Network.sendToServer(packet);
        }).centerAligned().complete();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseSellMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        if (this.confirmedDetails) {
            this.nameBox.m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.purchaseButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        } else {
            this.confirmDetailsButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.cancelButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyPressed, int val2, int shift) {
        return this.confirmedDetails && this.nameBox.m_7933_(keyPressed, val2, shift) || super.m_7933_(keyPressed, val2, shift);
    }

    public boolean m_5534_(char typed, int shift) {
        return this.confirmedDetails && this.nameBox.m_5534_(typed, shift) || super.m_5534_(typed, shift);
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTick) {
        return !this.confirmedDetails && this.confirmDetailsButton.m_6375_(mouseX, mouseY, partialTick) || this.confirmedDetails && this.purchaseButton.m_6375_(mouseX, mouseY, partialTick) || this.cancelButton.m_6375_(mouseX, mouseY, partialTick) || this.confirmedDetails && this.nameBox.m_6375_(mouseX, mouseY, partialTick) || super.m_6375_(mouseX, mouseY, partialTick);
    }
}

