/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.gait.Gait;
import com.equestricraft.core.horse.information.HorseStatsInformation;
import com.equestricraft.core.horse.stats.HorseStat;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECProgressBar;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseStatsScreen
extends Screen {
    private final HorseStatsInformation stats;
    private final List<SymbolInformation> symbols = new ArrayList<SymbolInformation>(0);

    public static void showHorseDataMenu(HorseSimple horse, HorseStatsInformation stats) {
        HorseStatsScreen prompt = new HorseStatsScreen(horse, stats);
        ScreenStack.getInstance().push(prompt);
    }

    private HorseStatsScreen(HorseSimple horse, HorseStatsInformation stats) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-stats-menu.title", horse.name())));
        this.stats = stats;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.createFields();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
    }

    private void createFields() {
        AtomicInteger currentX = new AtomicInteger(10);
        AtomicInteger currentY = new AtomicInteger(35);
        this.renderSpeedLabel(Gait.WALK_WORKING, this.stats.walkSpeed(), currentX, currentY);
        this.renderSpeedLabel(Gait.TROT_WORKING, this.stats.trotSpeed(), currentX, currentY);
        this.renderSpeedLabel(Gait.CANTER_WORKING, this.stats.canterSpeed(), currentX, currentY);
        this.renderSpeedLabel(Gait.GALLOP_FULL, this.stats.gallopSpeed(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.jump.label"), this.stats.jumpPower().value(), currentX, currentY);
        ECProgressBar maximumStaminaProgress = ECProgressBar.Builder.start(currentX.get(), currentY.get(), this.f_96543_ / 2 - 20).withLabel(I18n.getLabel("horse-stats-menu.field.stamina.label")).withValue((int)((double)(this.stats.currentMaximumStamina() / this.stats.baseMaximumStamina()) * 100.0 / 2.0)).complete();
        this.m_142416_((GuiEventListener)maximumStaminaProgress);
        this.moveLocation(currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.intelligence.label"), this.stats.intelligence(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.memory.label"), this.stats.memory(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.aggression.label"), this.stats.aggression(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.appetite.label"), this.stats.appetite(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.obedience.label"), this.stats.obedience(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.restlessness.label"), this.stats.restlessness(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.spookiness.label"), this.stats.spookiness(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.frustration.label"), this.stats.frustration(), currentX, currentY);
        this.renderStatBar(I18n.getLabel("horse-stats-menu.field.stress.label"), this.stats.stress(), currentX, currentY);
        this.moveLocation(currentX, currentY);
    }

    private void renderSpeedLabel(Gait gait, HorseStat speedStat, AtomicInteger currentX, AtomicInteger currentY) {
        int totalWidth = this.f_96543_ / 2 - 20;
        KeyPair keys2 = this.getSpeedKeys(gait);
        ECProgressBar speedProgressBar = ECProgressBar.Builder.start(currentX.get(), currentY.get(), totalWidth).withLabel(I18n.getLabel(keys2.label())).withValue((int)((double)speedStat.value() / (double)speedStat.baseValue() * 100.0 / 2.0)).complete();
        this.m_142416_((GuiEventListener)speedProgressBar);
        Optional<ResourceLocation> symbol = this.getSymbol(speedStat);
        if (symbol.isPresent()) {
            int x = currentX.get() + speedProgressBar.m_5711_() + 5;
            int y = currentY.get() - 1;
            SymbolInformation symbolInfo = new SymbolInformation(symbol.get(), x, y);
            this.symbols.add(symbolInfo);
        }
        this.moveLocation(currentX, currentY);
    }

    private void renderStatBar(String label, double value, AtomicInteger currentX, AtomicInteger currentY) {
        int totalWidth = this.f_96543_ / 2 - 20;
        ECProgressBar progressBar = ECProgressBar.Builder.start(currentX.get(), currentY.get(), totalWidth).withLabel(label).withValue((int)value).complete();
        this.m_142416_((GuiEventListener)progressBar);
        this.moveLocation(currentX, currentY);
    }

    private Optional<ResourceLocation> getSymbol(HorseStat speedValue) {
        if (speedValue.isIncreased()) {
            return Optional.ofNullable(Resources.getTextures().getGui().get("increase.png"));
        }
        if (speedValue.isImpaired()) {
            return Optional.ofNullable(Resources.getTextures().getGui().get("decrease.png"));
        }
        return Optional.empty();
    }

    private KeyPair getSpeedKeys(Gait gait) {
        return switch (gait) {
            case Gait.WALK_WORKING -> new KeyPair("horse-stats-menu.field.walk-speed.label", "horse-stats-menu.field.walk-speed.value");
            case Gait.TROT_WORKING -> new KeyPair("horse-stats-menu.field.trot-speed.label", "horse-stats-menu.field.trot-speed.value");
            case Gait.CANTER_WORKING -> new KeyPair("horse-stats-menu.field.canter-speed.label", "horse-stats-menu.field.canter-speed.value");
            case Gait.GALLOP_FULL -> new KeyPair("horse-stats-menu.field.gallop-speed.label", "horse-stats-menu.field.gallop-speed.value");
            default -> throw new IllegalArgumentException("Invalid key pair");
        };
    }

    private void moveLocation(AtomicInteger currentX, AtomicInteger currentY) {
        currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        if (currentY.get() >= 160) {
            currentX.set(this.f_96543_ / 2 + 10);
            currentY.set(35);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseStatsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        for (SymbolInformation symbol : this.symbols) {
            GuiUtil.drawImage(poseStack, symbol.resourceLocation(), symbol.x(), symbol.y(), GuiUtil.getStandardLineHeight(), GuiUtil.getStandardLineHeight());
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }

    private record KeyPair(String label, String value) {
    }

    private record SymbolInformation(ResourceLocation resourceLocation, int x, int y) {
    }
}

