/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.health.HorseHealth;
import com.equestricraft.core.horse.information.HorseWelfareInformation;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECProgressBar;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseViewMenuInteractPacket;
import com.equestricraft.mod.packet.ServerBoundPrescriptionListPageRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseWelfareScreen
extends Screen {
    private final HorseSimple horse;
    private final HorseWelfareInformation welfare;
    private ResourceLocation healthStatusIcon = null;

    public static void showMenu(HorseSimple horse, HorseWelfareInformation welfare) {
        HorseWelfareScreen screen = new HorseWelfareScreen(horse, welfare);
        ScreenStack.getInstance().push(screen);
    }

    public HorseWelfareScreen(HorseSimple horse, HorseWelfareInformation welfare) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-information-menu.welfare.title", horse.name())));
        this.horse = horse;
        this.welfare = welfare;
    }

    protected void m_7856_() {
        super.m_7856_();
        AtomicInteger currentY = new AtomicInteger(35);
        this.healthStatusIcon = this.getIconForHealthStatus(this.welfare.horseHealth());
        this.createLabels(currentY);
        currentY.addAndGet(5);
        this.createButtons(currentY);
    }

    private ResourceLocation getIconForHealthStatus(HorseHealth status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case HorseHealth.GREEN -> Resources.getTextures().getGui().get("green-tick.png");
            case HorseHealth.AMBER -> Resources.getTextures().getGui().get("warning_orange.png");
            case HorseHealth.RED -> Resources.getTextures().getGui().get("warning_red.png");
        };
    }

    private void createLabels(AtomicInteger currentY) {
        int largestBarLabel = 0;
        ECProgressBar fullnessBar = null;
        if (this.welfare.fullnessPercentage() != null) {
            fullnessBar = ECProgressBar.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.fullness.label")).withValue(this.welfare.fullnessPercentage()).withFilledColor(this.welfare.fullnessPercentage() > 10 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)fullnessBar);
            currentY.addAndGet(GuiUtil.getSpacedLineHeight());
            if (fullnessBar.getLabelWidth() > largestBarLabel) {
                largestBarLabel = fullnessBar.getLabelWidth();
            }
        }
        ECProgressBar hydrationBar = null;
        if (this.welfare.hydrationPercentage() != null) {
            hydrationBar = ECProgressBar.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.hydration.label")).withValue(this.welfare.hydrationPercentage()).withFilledColor(this.welfare.hydrationPercentage() > 10 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
            this.m_142416_((GuiEventListener)hydrationBar);
            currentY.addAndGet(GuiUtil.getSpacedLineHeight());
            if (hydrationBar.getLabelWidth() > largestBarLabel) {
                largestBarLabel = hydrationBar.getLabelWidth();
            }
        }
        ECProgressBar hoofCleanBar = ECProgressBar.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.hoof-cleanliness.label")).withValue(this.welfare.hoofCleanPercentage()).withFilledColor(this.welfare.hoofCleanPercentage() > 10 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
        this.m_142416_((GuiEventListener)hoofCleanBar);
        currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        if (hoofCleanBar.getLabelWidth() > largestBarLabel) {
            largestBarLabel = hoofCleanBar.getLabelWidth();
        }
        ECProgressBar cleanBar = ECProgressBar.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.cleanliness.label")).withValue(this.welfare.cleanPercentage()).withFilledColor(this.welfare.cleanPercentage() > 10 ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
        this.m_142416_((GuiEventListener)cleanBar);
        currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        if (cleanBar.getLabelWidth() > largestBarLabel) {
            largestBarLabel = cleanBar.getLabelWidth();
        }
        largestBarLabel += 5;
        if (fullnessBar != null) {
            fullnessBar.setTabSize(largestBarLabel);
        }
        if (hydrationBar != null) {
            hydrationBar.setTabSize(largestBarLabel);
        }
        hoofCleanBar.setTabSize(largestBarLabel);
        cleanBar.setTabSize(largestBarLabel);
        if (this.welfare.bloodType() != null) {
            ECField bloodTypeField = ECField.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.blood-type.label")).withValue(this.welfare.bloodType()).complete();
            this.m_142416_((GuiEventListener)bloodTypeField);
            currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        }
        ECField wormerField = ECField.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.wormer.label")).withValue(this.welfare.wormerActive() ? I18n.getLabel("common.yes") : I18n.getLabel("common.no")).withValueColor(this.welfare.wormerActive() ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
        this.m_142416_((GuiEventListener)wormerField);
        currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        ECField hoofLengthPercentage = ECField.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.hoof-length.label")).withValue(this.welfare.hoofLengthPercentage()).complete();
        this.m_142416_((GuiEventListener)hoofLengthPercentage);
        currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        ECField dailyCareField = ECField.Builder.start(10, currentY.get(), this.f_96543_ - 20).withLabel(I18n.getLabel("horse-information-menu.welfare.field.daily-care.label")).withValue(this.welfare.dailyCareComplete() ? I18n.getLabel("common.yes") : I18n.getLabel("common.no")).withValueColor(this.welfare.dailyCareComplete() ? Argb.ARGB_GREEN : Argb.ARGB_RED).complete();
        this.m_142416_((GuiEventListener)dailyCareField);
        currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        if (this.welfare.inHeat()) {
            ECField inHeat = ECField.Builder.start(10, currentY.get(), this.f_96543_ - 20).withValue(I18n.getLabel("horse-information-menu.welfare.field.in-heat.label")).withValueColor(Argb.ARGB_GREEN).complete();
            this.m_142416_((GuiEventListener)inHeat);
            currentY.addAndGet(GuiUtil.getSpacedLineHeight());
        }
    }

    private void createButtons(AtomicInteger currentY) {
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        int buttonWidth = 150;
        int buttonHeight = 20;
        int buttonSpacing = 3;
        int buttonSize = 20;
        int xPosition = this.f_96543_ / 2;
        if (this.welfare.hasIllnessesToShow()) {
            ECButton showIllnessesButton = ECButton.Builder.start(xPosition, currentY.get(), 150, 20).withLabel(I18n.getLabel("horse-information-menu.welfare.button.view-illnesses")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horse.id(), "ILLNESSES"))).withIcon(Resources.getTextures().getGui().get("medical_case_button.png"), 20, 20).centerAligned().complete();
            this.m_142416_((GuiEventListener)showIllnessesButton);
            currentY.addAndGet(23);
        }
        if (this.welfare.hasVisibleSymptoms()) {
            ECButton showSymptomsButton = ECButton.Builder.start(xPosition, currentY.get(), 150, 20).withLabel(I18n.getLabel("horse-information-menu.welfare.button.view-symptoms")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horse.id(), "SYMPTOMS"))).withIcon(Resources.getTextures().getGui().get("stethoscope_icon.png"), 20, 20).centerAligned().complete();
            this.m_142416_((GuiEventListener)showSymptomsButton);
            currentY.addAndGet(23);
        }
        if (this.welfare.hasVisibleMedicines()) {
            ECButton showMedicinesButton = ECButton.Builder.start(xPosition, currentY.get(), 150, 20).withLabel(I18n.getLabel("horse-information-menu.welfare.button.view-medicine-records")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horse.id(), "MEDICINES"))).withIcon(Resources.getTextures().getGui().get("syringe_icon.png"), 20, 20).centerAligned().complete();
            this.m_142416_((GuiEventListener)showMedicinesButton);
            currentY.addAndGet(23);
        }
        if (this.welfare.canViewVitamins()) {
            ECButton showVitaminsButton = ECButton.Builder.start(xPosition, currentY.get(), 150, 20).withLabel(I18n.getLabel("horse-information-menu.welfare.button.view-vitamins")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horse.id(), "VITAMINS"))).withIcon(Resources.getTextures().getGui().get("apple_icon.png"), 20, 20).centerAligned().complete();
            this.m_142416_((GuiEventListener)showVitaminsButton);
            currentY.addAndGet(23);
        }
        ECButton showPrescriptionsButton = ECButton.Builder.start(xPosition, currentY.get(), 150, 20).withLabel(I18n.getLabel("horse-information-menu.welfare.button.view-prescriptions")).withOnClick(() -> Network.sendToServer(new ServerBoundPrescriptionListPageRequestPacket(this.horse.id(), 1, SortDirection.ASCENDING))).withIcon(Resources.getTextures().getGui().get("medicine_icon.png"), 20, 20).centerAligned().complete();
        this.m_142416_((GuiEventListener)showPrescriptionsButton);
        currentY.addAndGet(23);
        ECButton showWorkNeedingDoneButton = ECButton.Builder.start(xPosition, currentY.get(), 150, 20).withLabel(I18n.getLabel("horse-information-menu.welfare.button.view-work-needing-done")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseViewMenuInteractPacket(this.horse.id(), "WORK_NEEDING_DONE_MAIN"))).withIcon(Resources.getTextures().getGui().get("briefcase_icon.png"), 20, 20).centerAligned().complete();
        this.m_142416_((GuiEventListener)showWorkNeedingDoneButton);
        currentY.addAndGet(23);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseWelfareScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        GuiUtil.drawImage(poseStack, this.healthStatusIcon, this.f_96543_ - 30, 10, 20, 20);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

