/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.access;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.access.HorsePlayerAccessPage;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.horse.access.HorsePlayerAccessWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseAccessAddPlayerPacket;
import com.equestricraft.mod.packet.ServerBoundHorseAccessRemovePlayerPacket;
import com.equestricraft.mod.packet.ServerBoundHorsePlayerAccessListShowPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class HorsePlayerAccessScreen
extends PageScreen<HorsePlayerAccessPage, PlayerSimple, Object, Object> {
    private final HorseSimple horse;

    public static void showScreen(HorseSimple horse, HorsePlayerAccessPage page) {
        HorsePlayerAccessScreen screen = new HorsePlayerAccessScreen(horse, page);
        ScreenStack.getInstance().push(screen);
    }

    private HorsePlayerAccessScreen(HorseSimple horse, HorsePlayerAccessPage page) {
        super(I18n.getLabel("horse.player-access.menu.title", horse.name()), page);
        this.horse = horse;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.createButtons();
        this.createList();
    }

    private void createButtons() {
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        ECButton addPlayer = ECButton.Builder.start(this.f_96543_ - 10, 10, 50, 20).withLabel(I18n.getLabel("horse.player-access.menu.button.add-player.label")).withOnClick(() -> Network.sendToServer(new ServerBoundHorseAccessAddPlayerPacket(this.horse.id()))).rightAligned().complete();
        this.m_142416_((GuiEventListener)addPlayer);
    }

    private void createList() {
        int y = 35;
        for (PlayerSimple entry : ((HorsePlayerAccessPage)this.page).getItems()) {
            HorsePlayerAccessWidget widget = new HorsePlayerAccessWidget(10, y, this.f_96543_ - 20, entry, this::onRemove);
            this.m_142416_((GuiEventListener)widget);
            y += widget.m_93694_() + 5;
        }
    }

    private void onRemove(PlayerSimple entry) {
        ServerBoundHorseAccessRemovePlayerPacket packet = new ServerBoundHorseAccessRemovePlayerPacket(this.horse.id(), entry.id());
        Network.sendToServer(packet);
    }

    @Override
    public void onChangePage(int newPageNumber) {
        ServerBoundHorsePlayerAccessListShowPacket packet = new ServerBoundHorsePlayerAccessListShowPacket(this.horse.id(), newPageNumber);
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorsePlayerAccessScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

