/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.breed;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.information.HorseBreedCertificateInformation;
import com.equestricraft.core.horse.information.HorseIndividualBreedViewItem;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.horse.breed.HorseBreedListItemWidget;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BreedCertificateScreen
extends Screen {
    private int scroll = 0;
    private int totalHeight = 0;
    private final HorseBreedCertificateInformation info;
    private final ResourceLocation certificateSymbol = Resources.getTextures().getGui().get("certificate_symbol.png");
    private TextComponent horseNameComponent = null;
    private TextComponent displayComponent = null;
    private ECMultiLineField breakdownLabel = null;
    private ECMultiLineField infoLabel = null;

    public static void showHorseBreedDataMenu(HorseBreedCertificateInformation info2) {
        BreedCertificateScreen prompt = new BreedCertificateScreen(info2);
        ScreenStack.getInstance().push(prompt);
    }

    private BreedCertificateScreen(HorseBreedCertificateInformation info2) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.breed-certificate.menu.title")));
        this.info = info2;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.horseNameComponent = ComponentUtil.buildColoredTextComponent(this.info.horseName());
        this.displayComponent = ComponentUtil.buildColoredTextComponent(this.info.display());
        if (this.info.breeds().isEmpty()) {
            this.infoLabel = ECMultiLineField.Builder.start().withLabel(I18n.getLabel("horse.breed-certificate.menu.not-classified.label")).withWidth(this.f_96543_ - 40).withPosition(this.f_96543_ / 2, this.f_96544_ / 2).centerAlign().complete();
        } else {
            this.breakdownLabel = ECMultiLineField.Builder.start().withLabel(I18n.getLabel("horse.breed-certificate.menu.breakdown.label")).withWidth(this.f_96543_ - 40).centerAlign().complete();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        BreedCertificateScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(10 + this.scroll), (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        BreedCertificateScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.horseNameComponent, (int)(this.f_96543_ / 2), (int)(25 + this.scroll), (int)GuiConstants.COLOR_WHITE);
        BreedCertificateScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.displayComponent, (int)(this.f_96543_ / 2), (int)(40 + this.scroll), (int)GuiConstants.COLOR_WHITE);
        GuiUtil.drawImage(poseStack, this.certificateSymbol, 20, 10 + this.scroll, 20, 20);
        if (this.infoLabel != null) {
            this.infoLabel.render(poseStack);
        }
        int x = 20;
        int y = 55;
        if (this.breakdownLabel != null) {
            this.breakdownLabel.position(this.f_96543_ / 2, y + this.scroll).render(poseStack);
            y += this.breakdownLabel.getHeight();
        }
        y += GuiUtil.getSpacedLineHeight();
        for (HorseIndividualBreedViewItem breed : this.info.breeds()) {
            HorseBreedListItemWidget breedCard = new HorseBreedListItemWidget(x, y + this.scroll, this.f_96543_ - 40, breed);
            y += breedCard.m_93694_() + 5;
            breedCard.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.totalHeight = y;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

