/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.conformation;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.conformation.check.ConformationCheckRating;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.horse.conformation.HorseConformationCheckInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;

public class HorseConformationCheckWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField ratingField;
    private final ECMultiLineField description;
    private ResourceLocation speedIcon = null;
    private ResourceLocation jumpIcon = null;
    private ResourceLocation staminaIcon = null;
    private int iconY = 0;

    protected HorseConformationCheckWidget(int x, int y, int width, HorseConformationCheckInfo info2) {
        super(x, y, width, 0);
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(info2.name()).withValueColor(Argb.ARGB_AQUA).complete();
        this.ratingField = ECField.Builder.start(this.dx(width), this.dy(0), width).withValue(I18n.getLabel(info2.rating().getKey())).withValueColor(this.getColorForRating(info2.rating())).rightAligned().complete();
        this.description = ECMultiLineField.Builder.start().withLabel(info2.description()).withPosition(this.dx(0), this.dy(GuiUtil.getSpacedLineHeight())).withWidth(width).complete();
        int currentY = GuiUtil.getSpacedLineHeight() + this.description.getHeight();
        boolean hasIcon = false;
        if (info2.speedEffect() != 0) {
            hasIcon = true;
            this.speedIcon = info2.speedEffect() > 0 ? Resources.getTextures().getGui().get("speed_increased.png") : Resources.getTextures().getGui().get("speed_decreased.png");
        }
        if (info2.jumpEffect() != 0) {
            hasIcon = true;
            this.jumpIcon = info2.jumpEffect() > 0 ? Resources.getTextures().getGui().get("jump_increased.png") : Resources.getTextures().getGui().get("jump_decreased.png");
        }
        if (info2.staminaEffect() != 0) {
            hasIcon = true;
            this.staminaIcon = info2.staminaEffect() > 0 ? Resources.getTextures().getGui().get("stamina_increased.png") : Resources.getTextures().getGui().get("stamina_decreased.png");
        }
        if (hasIcon) {
            this.iconY = currentY;
            currentY += 15;
        }
        this.f_93619_ = currentY + 10;
    }

    private Argb getColorForRating(ConformationCheckRating rating) {
        return switch (rating) {
            default -> throw new IncompatibleClassChangeError();
            case ConformationCheckRating.VERY_GOOD -> Argb.ARGB_GREEN;
            case ConformationCheckRating.GOOD -> Argb.ARGB_YELLOW;
            case ConformationCheckRating.OK -> Argb.ARGB_MC_GOLD;
            case ConformationCheckRating.POOR -> Argb.ARGB_RED;
            case ConformationCheckRating.VERY_POOR -> Argb.ARGB_MC_DARK_RED;
        };
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.f_93621_ = this.dy(0);
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.ratingField.f_93621_ = this.dy(0);
        this.ratingField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.description.position(this.dx(0), this.dy(GuiUtil.getSpacedLineHeight()));
        this.description.render(poseStack);
        int x = 0;
        if (this.speedIcon != null) {
            GuiUtil.drawImage(poseStack, this.speedIcon, this.dx(x), this.dy(this.iconY), 20, 10);
            x += 25;
        }
        if (this.jumpIcon != null) {
            GuiUtil.drawImage(poseStack, this.jumpIcon, this.dx(x), this.dy(this.iconY), 20, 10);
            x += 25;
        }
        if (this.staminaIcon != null) {
            GuiUtil.drawImage(poseStack, this.staminaIcon, this.dx(x), this.dy(this.iconY), 20, 10);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }
}

