/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.create;

import com.equestricraft.common.Argb;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseCoatModifiers;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.Range;
import com.equestricraft.common.genetic.NumericalGeneticValue;
import com.equestricraft.common.height.HorseHeight;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.breed.BreedInfo;
import com.equestricraft.core.horse.HorseConstants;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.create.HorseCreateBreedRequest;
import com.equestricraft.core.horse.create.ValidHorseCreateSelections;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECCheckbox;
import com.equestricraft.mod.client.gui.components.ECCheckboxGroup;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECNumberSpinner;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.client.gui.components.ScrollableList;
import com.equestricraft.mod.client.gui.components.ScrollableListItem;
import com.equestricraft.mod.client.gui.horse.color.HorseColorSelectScreen;
import com.equestricraft.mod.client.gui.horse.create.EnteredDetails;
import com.equestricraft.mod.client.gui.horse.create.HorseCreateMenuState;
import com.equestricraft.mod.client.gui.horse.marking.HorseMarkingSelectScreen;
import com.equestricraft.mod.client.gui.prompt.MessagePromptScreen;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundCustomHorseCreatePacket;
import com.equestricraft.mod.packet.ServerBoundHorseCreateAllBreedsRequestPacket;
import com.equestricraft.mod.packet.ServerBoundHorseCreateBreedRequestPacket;
import com.equestricraft.mod.packet.ServerBoundHorseCreateSelectionsRequestPacket;
import com.equestricraft.mod.packet.ServerBoundRequestRandomHorseNameForMenuPacket;
import com.equestricraft.mod.prompt.MessagePrompt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseCreateMenuScreen
extends Screen {
    private static HorseCreateMenuScreen menu = null;
    private ECField tokenField = null;
    private ECTextField nameInputBox;
    private ECNumberSpinner ageYears;
    private ECNumberSpinner ageMonths;
    private ECCheckbox grayCheckbox;
    private ECButton selectColorButton;
    private HorseCoatColor selectedColor = null;
    private ECButton selectMarkingButton;
    private List<HorseCoatMarking> selectedMarkings = new ArrayList<HorseCoatMarking>();
    private final ECCheckboxGroup<HorseGender> genderCheckboxGroup = new ECCheckboxGroup();
    private final Integer tokenBalance;
    private ECTextField heightInputBox;
    private ECTextField weightInputBox;
    private ScrollableList breedList;
    private final HorseCreateMenuState state = HorseCreateMenuState.getCurrent();
    private boolean breedSelectionMode = false;
    private boolean showFillOutAllFieldsError = false;
    private final String fillOutAllFieldsLabel = I18n.getLabel("horse-create.menu.error.fill-out-all-fields");

    public static void showScreen(Integer tokenBalance) {
        menu = new HorseCreateMenuScreen(tokenBalance);
        Minecraft.m_91087_().m_91152_((Screen)menu);
    }

    public static void setName(String name) {
        if (menu != null) {
            HorseCreateMenuScreen.menu.nameInputBox.setValue(name);
        }
    }

    public static void setBreeds(List<BreedInfo> breeds) {
        if (menu != null) {
            HorseCreateMenuState state = HorseCreateMenuScreen.menu.state;
            state.setBreeds(breeds);
            HorseCreateMenuScreen.menu.breedList.setOptions(state.getBreeds().stream().map(b -> new ScrollableListItem(b.breedId(), b.breedName())).toList());
        }
    }

    public static void setValidSelections(ValidHorseCreateSelections selections) {
        if (menu != null) {
            HorseCreateMenuState state = HorseCreateMenuScreen.buildState(selections);
            if (HorseCreateMenuScreen.menu.selectedColor != null && !state.getAvailableColors().contains((Object)HorseCreateMenuScreen.menu.selectedColor)) {
                HorseCreateMenuScreen.menu.selectedColor = null;
            }
            HorseCreateMenuScreen.menu.selectedMarkings.removeIf(Predicate.not(state.getAvailableMarkings()::contains));
            HorseCreateMenuScreen.menu.selectedMarkings.addAll(state.getRequiredMarkings());
            HorseCreateMenuScreen.menu.selectedMarkings.removeIf(Predicate.not(m -> state.getAvailableMarkingGroups().contains((Object)m.getGroup())));
            HorseCreateMenuScreen.menu.heightInputBox.setValue("" + (selections.minimumHeight() + selections.maximumHeight()) / 2.0);
            double weight = switch (HorseCreateMenuScreen.menu.state.getEnteredDetails().gender()) {
                default -> throw new IncompatibleClassChangeError();
                case HorseGender.STALLION, HorseGender.GELDING -> (selections.stallionMinimumWeight() + selections.stallionMaximumWeight()) / 2.0;
                case HorseGender.MARE -> (selections.mareMinimumWeight() + selections.mareMaximumWeight()) / 2.0;
            };
            HorseCreateMenuScreen.menu.weightInputBox.setValue("" + weight);
        }
    }

    private static HorseCreateMenuState buildState(ValidHorseCreateSelections selections) {
        HorseCreateMenuState state = HorseCreateMenuScreen.menu.state;
        state.setAvailableColors(selections.colors());
        state.setAvailableMarkings(selections.allMarkings());
        state.setRequiredMarkings(selections.requiredMarkings());
        state.setAvailableMarkingGroups(selections.allMarkingGroups());
        state.setRequiredMarkingGroups(selections.requiredMarkingGroups());
        state.setMinimumHeight(selections.minimumHeight());
        state.setMaximumHeight(selections.maximumHeight());
        state.setStallionMinimumWeight(selections.stallionMinimumWeight());
        state.setStallionMaximumWeight(selections.stallionMaximumWeight());
        state.setMareMinimumWeight(selections.mareMinimumWeight());
        state.setMareMaximumWeight(selections.mareMaximumWeight());
        return state;
    }

    private HorseCreateMenuScreen(Integer tokenBalance) {
        super((Component)new TextComponent(I18n.getLabel("horse-create.menu.title")));
        this.tokenBalance = tokenBalance;
    }

    protected void m_7856_() {
        int xMargin = 10;
        int xMarginOffset = xMargin * 2;
        int currentY = 25;
        if (this.tokenBalance != null) {
            this.tokenField = ECField.Builder.start(xMargin, currentY, 80).withLabel(I18n.getLabel("horse-create.menu.field.token-balance.label")).withValue(this.tokenBalance).complete();
            currentY += this.tokenField.m_93694_() + 5;
        }
        EnteredDetails enteredDetails = this.state.getEnteredDetails();
        this.nameInputBox = ECTextField.Builder.start(xMargin, currentY, this.f_96543_ - 70).withLabel(I18n.getLabel("horse-create.menu.field.name.label")).withDefaultValue(enteredDetails != null ? enteredDetails.name() : null).withMaximumLength(HorseConstants.MAXIMUM_NAME_LENGTH).complete();
        this.m_142416_((GuiEventListener)this.nameInputBox);
        this.m_94718_((GuiEventListener)this.nameInputBox);
        ECButton randomNameButton = ECButton.Builder.start(this.f_96543_ - 50, currentY, 50, 20).withLabel(I18n.getLabel("horse-create.menu.button.random-name.label")).withOnClick(() -> {
            ServerBoundRequestRandomHorseNameForMenuPacket packet = new ServerBoundRequestRandomHorseNameForMenuPacket();
            Network.sendToServer(packet);
        }).complete();
        this.m_142416_((GuiEventListener)randomNameButton);
        ECField genderLabel = ECField.Builder.start(xMargin, currentY += 25, 50).withLabel(I18n.getLabel("horse-create.menu.field.gender.label")).complete();
        this.m_142416_((GuiEventListener)genderLabel);
        ECCheckbox<HorseGender> stallionCheckbox = ECCheckbox.Builder.start(genderLabel.f_93620_ + genderLabel.m_5711_() + 10, currentY).withText(HorseGender.STALLION.getTranslatedName()).withOptionValue(HorseGender.STALLION).withDefaultSelected(enteredDetails == null || enteredDetails.gender() == HorseGender.STALLION).withGroup(this.genderCheckboxGroup).complete();
        this.m_142416_((GuiEventListener)stallionCheckbox);
        ECCheckbox<HorseGender> mareCheckbox = ECCheckbox.Builder.start(stallionCheckbox.f_93620_ + stallionCheckbox.m_5711_() + 10, currentY).withText(HorseGender.MARE.getTranslatedName()).withOptionValue(HorseGender.MARE).withDefaultSelected(enteredDetails != null && enteredDetails.gender() == HorseGender.MARE).withGroup(this.genderCheckboxGroup).complete();
        this.m_142416_((GuiEventListener)mareCheckbox);
        ECField ageLabel = ECField.Builder.start(xMargin, currentY += 30, 50).withLabel(I18n.getLabel("horse-create.menu.field.age.label")).complete();
        this.m_142416_((GuiEventListener)ageLabel);
        this.ageYears = ECNumberSpinner.Builder.start(ageLabel.f_93620_ + ageLabel.m_5711_() + 10, currentY).withLabel(I18n.getLabel("horse-create.menu.field.age.label.years")).withMinValue(0).withMaxValue(99).complete();
        this.m_142416_((GuiEventListener)this.ageYears);
        this.ageMonths = ECNumberSpinner.Builder.start(this.ageYears.f_93620_ + this.ageYears.m_5711_() + 10, currentY).withLabel(I18n.getLabel("horse-create.menu.field.age.label.months")).withMinValue(0).withMaxValue(11).complete();
        this.m_142416_((GuiEventListener)this.ageMonths);
        this.grayCheckbox = ECCheckbox.Builder.start(this.f_96543_ - 80, currentY).withText(I18n.getLabel("horse-create.menu.field.gray.label")).withDefaultSelected(enteredDetails != null && enteredDetails.modifiers().isGray()).complete();
        this.m_142416_((GuiEventListener)this.grayCheckbox);
        this.selectedColor = enteredDetails != null ? enteredDetails.colorSimple() : null;
        this.selectColorButton = ECButton.Builder.start(xMargin, currentY += 25, 100, 20).withLabel(this.selectedColor == null ? I18n.getLabel("horse-create.menu.field.coat-color.label") : I18n.getLabel(this.selectedColor.getLabel())).withOnClick(this::onColorSelectionClick).complete();
        this.m_142416_((GuiEventListener)this.selectColorButton);
        this.selectedMarkings = enteredDetails != null ? enteredDetails.modifiers().getMarkingSelections() : new ArrayList();
        this.selectMarkingButton = ECButton.Builder.start(this.selectColorButton.f_93620_ + this.selectColorButton.m_5711_() + 10, currentY, 100, 20).withLabel(I18n.getLabel("horse-create.menu.field.marking.label", this.selectedMarkings.size())).withOnClick(this::onMarkingSelectionClick).complete();
        this.m_142416_((GuiEventListener)this.selectMarkingButton);
        int heightX = this.selectMarkingButton.f_93620_ + this.selectMarkingButton.m_5711_() + 10;
        this.heightInputBox = ECTextField.Builder.start(heightX, currentY, 80).withLabel(I18n.getLabel("horse-create.menu.field.height.label")).withDefaultValue((String)(enteredDetails != null ? "" + HorseHeight.ofMeters(enteredDetails.horseHeight()).getHands() : "12.3")).complete();
        this.m_142416_((GuiEventListener)this.heightInputBox);
        int weightX = this.heightInputBox.f_93620_ + this.heightInputBox.m_5711_() + 10;
        this.weightInputBox = ECTextField.Builder.start(weightX, currentY, 80).withLabel(I18n.getLabel("horse-create.menu.field.weight.label")).withDefaultValue((String)(enteredDetails != null ? "" + enteredDetails.horseWeight() : "500.0")).complete();
        this.m_142416_((GuiEventListener)this.weightInputBox);
        ECButton requestAllBreedsButton = ECButton.Builder.start(xMargin, currentY += 30, 100, 20).withLabel(I18n.getLabel("horse-create.menu.button.request-all-breeds.label")).withOnClick(this::requestAllBreeds).complete();
        this.m_142416_((GuiEventListener)requestAllBreedsButton);
        ECField breedLabel = ECField.Builder.start(xMargin, currentY += 25, this.f_96543_ - xMarginOffset).withLabel(I18n.getLabel("horse-create.menu.field.breed.label")).complete();
        this.m_142416_((GuiEventListener)breedLabel);
        this.breedList = new ScrollableList(xMargin, currentY += breedLabel.m_93694_() + 5, this.f_96543_ - xMarginOffset, 20, this.state.getBreeds().stream().map(b -> new ScrollableListItem(b.breedId(), b.breedName())).toList(), 1);
        this.breedList.onSelectionChanged(this::onBreedSelectionChange);
        if (enteredDetails != null) {
            this.breedList.setSelected(Collections.singletonList(enteredDetails.breedId()));
            this.breedSelectionMode = enteredDetails.breedSelectionMode();
        }
        this.m_142416_((GuiEventListener)this.breedList);
        ECButton okButton = ECButton.Builder.start(this.f_96543_ / 2, this.f_96544_ - 30, 150, 20).withLabel(I18n.getLabel("common.ok")).withOnClick(this::onOkClick).centerAligned().complete();
        this.m_142416_((GuiEventListener)okButton);
        ECButton clearButton = ECButton.Builder.start(this.f_96543_ - 80, this.f_96544_ - 30, 70, 20).withLabel(I18n.getLabel("common.clear")).withOnClick(() -> {
            this.state.setEnteredDetails(null);
            this.m_7379_();
            HorseCreateMenuScreen.showScreen(this.tokenBalance);
        }).complete();
        this.m_142416_((GuiEventListener)clearButton);
        if (enteredDetails != null) {
            this.nameInputBox.setValue(enteredDetails.name());
            if (enteredDetails.gender() != null) {
                if (enteredDetails.gender() == HorseGender.STALLION) {
                    stallionCheckbox.select();
                } else if (enteredDetails.gender() == HorseGender.MARE) {
                    mareCheckbox.select();
                }
            }
            int years = enteredDetails.age() / 12;
            int months = enteredDetails.age() % 12;
            this.ageYears.setValue(years);
            this.ageMonths.setValue(months);
            if (enteredDetails.colorSimple() != null) {
                this.selectedColor = enteredDetails.colorSimple();
            }
            this.selectedMarkings = enteredDetails.modifiers().getMarkingSelections();
        }
    }

    private void onColorSelectionClick() {
        this.saveState();
        HorseColorSelectScreen.showScreen(this.state.getAvailableColors(), color -> {
            this.selectedColor = color;
            this.saveState();
            this.selectColorButton.setLabel(this.selectedColor == null ? I18n.getLabel("horse-create.menu.field.coat-color.label") : I18n.getLabel(this.selectedColor.getLabel()));
            HorseCreateMenuScreen.showScreen(this.tokenBalance);
        });
    }

    private void onMarkingSelectionClick() {
        this.saveState();
        HorseMarkingSelectScreen.showScreen(this.state.getAvailableMarkings(), this.selectedMarkings, markings -> {
            this.selectedMarkings = markings;
            this.state.getRequiredMarkings().stream().filter(Predicate.not(this.selectedMarkings::contains)).forEach(this.selectedMarkings::add);
            this.saveState();
            this.selectMarkingButton.setLabel(I18n.getLabel("horse-create.menu.field.marking.label", this.selectedMarkings.size()));
            HorseCreateMenuScreen.showScreen(this.tokenBalance);
        });
    }

    private void onBreedSelectionChange(List<Integer> selection) {
        this.saveState();
        if (!selection.isEmpty()) {
            ServerBoundHorseCreateSelectionsRequestPacket packet = new ServerBoundHorseCreateSelectionsRequestPacket(selection.get(0));
            Network.sendToServer(packet);
        }
    }

    private void onOkClick() {
        if (this.formFilledOut() && this.isValid()) {
            EnteredDetails enteredDetails = this.state.getEnteredDetails();
            ServerBoundCustomHorseCreatePacket packet = new ServerBoundCustomHorseCreatePacket(enteredDetails.name(), enteredDetails.gender(), enteredDetails.age(), enteredDetails.colorSimple(), enteredDetails.modifiers(), enteredDetails.breedId(), enteredDetails.horseHeight());
            HorseCreateMenuState.reset();
            this.m_7379_();
            Network.sendToServer(packet);
        } else {
            this.showFillOutAllFieldsError = true;
        }
    }

    private boolean saveState() {
        String name = this.nameInputBox.getValue();
        HorseGender selectedGender = this.genderCheckboxGroup.getSelected().orElse(HorseGender.STALLION);
        int totalAgeMonths = this.ageYears.getValue() * 12 + this.ageMonths.getValue();
        boolean gray = this.grayCheckbox.isSelected();
        HorseCoatModifiers modifiers = new HorseCoatModifiers(gray, this.selectedMarkings);
        List<Integer> selectedIds = this.breedList.getSelected();
        Integer breedId = selectedIds.isEmpty() ? null : selectedIds.get(0);
        try {
            double horseHeightValue = HorseHeight.ofHands(Double.parseDouble(this.heightInputBox.getValue())).getMeters();
            double horseWeightValue = Double.parseDouble(this.weightInputBox.getValue());
            EnteredDetails enteredDetails = new EnteredDetails(name, selectedGender, totalAgeMonths, this.selectedColor, modifiers, breedId, horseHeightValue, horseWeightValue, this.breedSelectionMode);
            this.state.setEnteredDetails(enteredDetails);
            if (!this.breedSelectionMode) {
                this.sendBreedRequestUpdate();
            }
            return true;
        }
        catch (Exception ex) {
            MessagePromptScreen.showMessagePromptScreen(UUID.randomUUID(), "Horse Create", "Invalid height entered, must be a valid hh value", MessagePrompt.MessagePromptType.ERROR);
            return false;
        }
    }

    private boolean formFilledOut() {
        if (!this.saveState()) {
            return false;
        }
        if (this.nameInputBox.getValue().isEmpty()) {
            return false;
        }
        if (this.selectedColor == null) {
            return false;
        }
        if (this.state.getEnteredDetails().breedId() == null) {
            return false;
        }
        return this.genderCheckboxGroup.hasSelection();
    }

    private boolean isValid() {
        boolean valid = this.formFilledOut();
        EnteredDetails enteredDetails = this.state.getEnteredDetails();
        if (this.validateHeightField(enteredDetails)) {
            valid = false;
        }
        if (this.validateWeightField(enteredDetails)) {
            valid = false;
        }
        if (this.validateMarkingGroup()) {
            valid = false;
        }
        return valid;
    }

    private boolean validateHeightField(EnteredDetails enteredDetails) {
        double height = HorseHeight.ofMeters(enteredDetails.horseHeight()).getHands();
        if (this.state.getMinimumHeight() != null && height < this.state.getMinimumHeight()) {
            this.heightInputBox.setError(true);
            return true;
        }
        if (this.state.getMaximumHeight() != null && height > this.state.getMaximumHeight()) {
            this.heightInputBox.setError(true);
            return true;
        }
        this.heightInputBox.setError(false);
        return false;
    }

    private boolean validateWeightField(EnteredDetails enteredDetails) {
        if (this.state.getStallionMinimumWeight() == null) {
            return false;
        }
        Range<Double> range = switch (enteredDetails.gender()) {
            default -> throw new IncompatibleClassChangeError();
            case HorseGender.STALLION, HorseGender.GELDING -> Range.of(this.state.getStallionMinimumWeight(), this.state.getStallionMaximumWeight());
            case HorseGender.MARE -> Range.of(this.state.getMareMinimumWeight(), this.state.getMareMaximumWeight());
        };
        boolean valid = range.containsValueWithin(enteredDetails.horseWeight());
        if (!valid) {
            this.weightInputBox.setError(true);
        }
        return !valid;
    }

    private boolean validateMarkingGroup() {
        if (this.state.getAvailableMarkingGroups().isEmpty()) {
            return false;
        }
        List<HorseCoatMarking.MarkingGroup> selectedMarkingGroups = this.selectedMarkings.stream().map(HorseCoatMarking::getGroup).distinct().toList();
        if (selectedMarkingGroups.stream().anyMatch(Predicate.not(this.state.getAvailableMarkingGroups()::contains))) {
            return true;
        }
        ArrayList<HorseCoatMarking.MarkingGroup> groups2 = new ArrayList<HorseCoatMarking.MarkingGroup>(selectedMarkingGroups);
        return !groups2.containsAll(this.state.getRequiredMarkingGroups());
    }

    private void sendBreedRequestUpdate() {
        EnteredDetails enteredDetails = this.state.getEnteredDetails();
        if (enteredDetails.colorSimple() == null || enteredDetails.modifiers() == null) {
            return;
        }
        HorseCoatDetails coatDetails = HorseCoatDetails.Builder.start().withColor(enteredDetails.colorSimple()).withMarkings(enteredDetails.modifiers().getMarkingSelections()).withGrayScale(enteredDetails.modifiers().isGray() ? 1.0f : 0.0f).complete();
        NumericalGeneticValue baseHeight = new NumericalGeneticValue(enteredDetails.horseHeight(), enteredDetails.horseHeight());
        NumericalGeneticValue baseWeight = new NumericalGeneticValue(enteredDetails.horseWeight(), enteredDetails.horseWeight());
        HorseCreateBreedRequest breedRequest = new HorseCreateBreedRequest(coatDetails, baseHeight, baseWeight, enteredDetails.gender());
        ServerBoundHorseCreateBreedRequestPacket packet = new ServerBoundHorseCreateBreedRequestPacket(breedRequest);
        Network.sendToServer(packet);
    }

    private void requestAllBreeds() {
        this.breedSelectionMode = true;
        this.saveState();
        Network.sendToServer(new ServerBoundHorseCreateAllBreedsRequestPacket());
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseCreateMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        if (this.tokenField != null) {
            this.tokenField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        HorseCreateMenuScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.nameInputBox.m_6035_().getString(), (int)(this.nameInputBox.f_93620_ - this.f_96547_.m_92852_((FormattedText)this.nameInputBox.m_6035_()) - 5), (int)this.nameInputBox.f_93621_, (int)GuiConstants.COLOR_WHITE);
        if (this.showFillOutAllFieldsError) {
            HorseCreateMenuScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.fillOutAllFieldsLabel, (int)(this.f_96543_ / 2), (int)(this.f_96543_ - 10), (int)Argb.ARGB_RED.getIntValue());
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

