/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.dead;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.horse.dead.DeadHorseWidget;
import com.equestricraft.mod.horse.dead.DeadHorseListItem;
import com.equestricraft.mod.horse.dead.DeadHorseListPage;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundDeadHorseSelectChangePagePacket;
import com.equestricraft.mod.packet.ServerBoundDeadHorseSelectPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DeadHorseSelectPromptScreen
extends PageScreen<DeadHorseListPage, DeadHorseListItem, Object, String> {
    private final UUID uuid;
    private boolean sendCancel = true;

    public static void showScreen(UUID uuid, DeadHorseListPage page) {
        DeadHorseSelectPromptScreen screen = new DeadHorseSelectPromptScreen(uuid, page);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private DeadHorseSelectPromptScreen(UUID uuid, DeadHorseListPage page) {
        super(I18n.getLabel("horse.dead-horse-select.menu.title"), page);
        this.uuid = uuid;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initItems();
    }

    private void initItems() {
        int x = 20;
        int y = 35;
        int widgetWidth = (this.f_96543_ - 40) / 2;
        for (DeadHorseListItem item : ((DeadHorseListPage)this.page).getItems()) {
            DeadHorseWidget widget = new DeadHorseWidget(x, y, widgetWidth, 60, item, i -> {
                this.sendCancel = false;
                this.m_7379_();
                ServerBoundDeadHorseSelectPacket packet = new ServerBoundDeadHorseSelectPacket(this.uuid, i.id());
                Network.sendToServer(packet);
            });
            this.m_142416_((GuiEventListener)widget);
            if ((x += widgetWidth) + widgetWidth <= this.f_96543_ - 20) continue;
            x = 20;
            y += 75;
        }
    }

    @Override
    public void onChangePage(int newPageNumber) {
        this.sendCancel = false;
        ServerBoundDeadHorseSelectChangePagePacket packet = new ServerBoundDeadHorseSelectChangePagePacket(this.uuid, newPageNumber, (String)((DeadHorseListPage)this.page).getFilterObject());
        Network.sendToServer(packet);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        DeadHorseSelectPromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.sendCancel) {
            ServerBoundDeadHorseSelectPacket packet = new ServerBoundDeadHorseSelectPacket(this.uuid, null);
            Network.sendToServer(packet);
        }
    }
}

