/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.discipline;

import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.horse.discipline.HorseDisciplineListWidget;
import com.equestricraft.mod.horse.discipline.HorseDisciplineInfo;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Date;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseDisciplineScreen
extends Screen {
    private ECMultiLineField descriptionLabel = null;
    private HorseDisciplineListWidget disciplineListWidget;
    private final String lastCertificationLabelText = I18n.getLabel("horse.disciplines-menu.last-certification");
    private final HorseSimple horse;
    private final String lastCertificationValueText;
    private final List<HorseDisciplineInfo> infoList;

    public static void showScreen(HorseSimple horse, Date lastCertification, List<HorseDisciplineInfo> infoList) {
        HorseDisciplineScreen screen = new HorseDisciplineScreen(horse, lastCertification, infoList);
        ScreenStack.getInstance().push(screen);
    }

    protected HorseDisciplineScreen(HorseSimple horse, Date lastCertification, List<HorseDisciplineInfo> infoList) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse.disciplines-menu.title", horse.name())));
        this.horse = horse;
        this.lastCertificationValueText = lastCertification != null ? DateFormatter.formatDateDateMonthYear(lastCertification) : null;
        this.infoList = infoList;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
        this.descriptionLabel = ECMultiLineField.Builder.start().withLabel(I18n.getLabel("horse.disciplines-menu.description")).withWidth(this.f_96543_ - 40).centerAlign().complete();
        this.disciplineListWidget = new HorseDisciplineListWidget(10, 35, this.f_96543_ - 20, 0, this.infoList);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseDisciplineScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        int y = 25;
        if (this.lastCertificationValueText != null) {
            ECField lastCertificationLabel = ECField.Builder.start(this.f_96543_ / 2, y, this.f_96543_).withLabel(this.lastCertificationLabelText).withValue(this.lastCertificationValueText).centerAligned().complete();
            lastCertificationLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
            y += GuiUtil.getSpacedLineHeight();
        }
        this.descriptionLabel.position(this.f_96543_ / 2, y).render(poseStack);
        this.disciplineListWidget.f_93621_ = y += this.descriptionLabel.getHeight() + GuiUtil.getSpacedLineHeight();
        this.disciplineListWidget.setHeight(this.f_96544_ - (y + 10));
        this.disciplineListWidget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.disciplineListWidget.m_6050_(mouseX, mouseY, scroll) || super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int action) {
        return this.disciplineListWidget.m_6375_(mouseX, mouseY, action) || super.m_6375_(mouseX, mouseY, action);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

