/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.illness;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.horse.illness.HorseIllnessDetailsInfo;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class HorseIllnessDetailsScreen
extends Screen {
    private final HorseIllnessDetailsInfo horseIllnessDetailsInfo;
    private int scroll = 0;
    private int totalHeight = 0;
    private final String durationLabel = I18n.getLabel("illness.menu.duration.label");
    private final String noteLabel = I18n.getLabel("illness.menu.note.label");

    public static void showScreen(HorseIllnessDetailsInfo horseIllnessDetailsInfo) {
        HorseIllnessDetailsScreen screen = new HorseIllnessDetailsScreen(horseIllnessDetailsInfo);
        ScreenStack.getInstance().push(screen);
    }

    private HorseIllnessDetailsScreen(HorseIllnessDetailsInfo horseIllnessDetailsInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(horseIllnessDetailsInfo.illnessName()));
        this.horseIllnessDetailsInfo = horseIllnessDetailsInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BackButton(10, 10));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ECField medicineLabel;
        this.m_7333_(poseStack);
        HorseIllnessDetailsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(10 + this.scroll), (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        int y = 35 + this.scroll;
        ECField durationField = ECField.Builder.start(10, y, this.f_96543_ - 20).withLabel(this.durationLabel).withValue(this.horseIllnessDetailsInfo.durationDisplay()).complete();
        durationField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ECMultiLineField illnessDescriptionLabel = ECMultiLineField.Builder.start().withLabel(this.horseIllnessDetailsInfo.illnessDescription()).withWidth(this.f_96543_ - 20).withPosition(10, y += 15).complete();
        illnessDescriptionLabel.render(poseStack);
        y += illnessDescriptionLabel.getHeight() + GuiUtil.getStandardLineHeight();
        if (this.horseIllnessDetailsInfo.notes() != null) {
            medicineLabel = ECField.Builder.start(10, y, this.f_96543_ - 20).withLabel(this.noteLabel).complete();
            medicineLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
            ECMultiLineField notesLabel = ECMultiLineField.Builder.start().withLabel(this.horseIllnessDetailsInfo.notes()).withWidth(this.f_96543_ - 20).withPosition(10, y += GuiUtil.getStandardLineHeight()).complete();
            notesLabel.render(poseStack);
            y += notesLabel.getHeight() + GuiUtil.getStandardLineHeight();
        }
        if (!this.horseIllnessDetailsInfo.medicines().isEmpty()) {
            medicineLabel = ECField.Builder.start(10, y, this.f_96543_ - 20).withLabel(I18n.getLabel("illness.menu.medicine.header.label")).complete();
            medicineLabel.m_6305_(poseStack, mouseX, mouseY, partialTick);
            y += 15;
            for (HorseIllnessDetailsInfo.MedicineInfo medicine : this.horseIllnessDetailsInfo.medicines()) {
                ECField label = ECField.Builder.start(10, y, this.f_96543_ - 20).withValue(" - " + medicine.medicineName()).withValueColor(Argb.ARGB_WHITE).complete();
                label.m_6305_(poseStack, mouseX, mouseY, partialTick);
                y += GuiUtil.getSpacedLineHeight();
            }
        }
        this.totalHeight = y += 5;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

