/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.illness;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.information.HorseIllnessViewInformation;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.BackButton;
import com.equestricraft.mod.client.gui.horse.illness.HorseIllnessWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseIllnessDetailsMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundHorseIllnessDiagnosisPacket;
import com.equestricraft.mod.packet.ServerBoundPrescribeMedicinePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseIllnessScreen
extends Screen {
    private int scroll = 0;
    private int totalHeight = 0;
    private final HorseSimple horse;
    private final List<HorseIllnessViewInformation> illnesses;
    private final boolean diagnosisMode;
    private List<HorseIllnessWidget> widgets = new ArrayList<HorseIllnessWidget>(0);

    public static void showHorseIllnessesMenu(HorseSimple horse, List<HorseIllnessViewInformation> illnesses, boolean diagnosisMode) {
        HorseIllnessScreen prompt = new HorseIllnessScreen(horse, illnesses, diagnosisMode);
        ScreenStack.getInstance().push(prompt);
    }

    protected HorseIllnessScreen(HorseSimple horse, List<HorseIllnessViewInformation> illnesses, boolean diagnosisMode) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("horse-illnesses.menu.title", horse.name())));
        this.horse = horse;
        this.illnesses = illnesses;
        this.diagnosisMode = diagnosisMode;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.diagnosisMode) {
            this.m_142416_((GuiEventListener)new BackButton(10, 10));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        HorseIllnessScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(10 + this.scroll), (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        int x = 10;
        int y = 35;
        this.widgets = new ArrayList<HorseIllnessWidget>(this.illnesses.size());
        for (HorseIllnessViewInformation illness : this.illnesses) {
            HorseIllnessWidget widget = new HorseIllnessWidget(x, y + this.scroll, this.f_96543_ - 20, illness, this.diagnosisMode, this::onItemClick, this::onDiagnoseClick, this::onPrescribeClick);
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.widgets.add(widget);
            y += widget.m_93694_() + 5;
        }
        this.totalHeight = y;
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onItemClick(HorseIllnessViewInformation illness) {
        ServerBoundHorseIllnessDetailsMenuOpenPacket packet = new ServerBoundHorseIllnessDetailsMenuOpenPacket(this.horse.id(), illness.illnessId());
        Network.sendToServer(packet);
    }

    private void onDiagnoseClick(HorseIllnessViewInformation illness) {
        this.m_7379_();
        ServerBoundHorseIllnessDiagnosisPacket packet = new ServerBoundHorseIllnessDiagnosisPacket(this.horse.id(), illness.illnessId());
        Network.sendToServer(packet);
    }

    private void onPrescribeClick(HorseIllnessViewInformation illness) {
        this.m_7379_();
        ServerBoundPrescribeMedicinePacket packet = new ServerBoundPrescribeMedicinePacket(this.horse.id(), illness.illnessId());
        Network.sendToServer(packet);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            double limit = (double)this.totalHeight - (double)this.f_96544_ / 2.0 + 10.0;
            if (Math.abs(newVal) > limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTick) {
        for (HorseIllnessWidget widget : this.widgets) {
            if (!widget.m_6375_(mouseX, mouseY, partialTick)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

