/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.illness;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.information.HorseIllnessViewInformation;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECProgressBar;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class HorseIllnessWidget
extends ECWidget {
    private final HorseIllnessViewInformation illness;
    private final Consumer<HorseIllnessViewInformation> onItemClick;
    private final ECField nameField;
    private final ECField hoursSinceContractedField;
    private final ECMultiLineField notesField;
    private final int notesYLevel;
    private final ECMultiLineField descriptionField;
    private final int descriptionYLevel;
    private final ECField diagnosisCostField;
    private final ECButton diagnoseButton;
    private final ECButton prescribeButton;
    private final boolean diagnosisMode;
    private final ECProgressBar cureProgress;

    protected HorseIllnessWidget(int x, int y, int width, HorseIllnessViewInformation illness, boolean diagnosisMode, Consumer<HorseIllnessViewInformation> onItemClick, Consumer<HorseIllnessViewInformation> onDiagnoseClick, Consumer<HorseIllnessViewInformation> onPrescribeClick) {
        super(x, y, width, 0);
        this.illness = illness;
        this.diagnosisMode = diagnosisMode;
        this.onItemClick = onItemClick;
        int currentY = 5;
        this.nameField = ECField.Builder.start(this.dx(5), this.dy(currentY), width - 10).withValue(illness.illnessName()).complete();
        this.hoursSinceContractedField = ECField.Builder.start(this.dx(width - 5), this.dy(currentY), width - 10).withValue(illness.durationDisplay()).rightAligned().complete();
        currentY += GuiUtil.getSpacedLineHeight();
        if (illness.notes() != null) {
            this.notesField = ECMultiLineField.Builder.start().withLabel(illness.notes()).withWidth(width - 20).withColor(Argb.ARGB_MC_GREEN).complete();
            this.notesYLevel = currentY;
            currentY += this.notesField.getHeight();
            currentY += 5;
        } else {
            this.notesField = null;
            this.notesYLevel = 0;
        }
        if (illness.diagnosisCostDisplay() != null) {
            this.diagnosisCostField = ECField.Builder.start(this.dx(5), this.dy(currentY), width - 10).withLabel(I18n.getLabel("horse-illnesses.menu.field.diagnosis-cost.label")).withValue(illness.diagnosisCostDisplay()).complete();
            currentY += 15;
        } else {
            this.diagnosisCostField = null;
        }
        String descriptionMessage = illness.messageForTrainedPlayers() != null ? illness.messageForTrainedPlayers() + "\n\n" + illness.illnessDescription() : illness.illnessDescription();
        this.descriptionField = ECMultiLineField.Builder.start().withLabel(descriptionMessage).withWidth(width - 10).complete();
        this.descriptionYLevel = currentY;
        currentY += this.descriptionField.getHeight();
        if (diagnosisMode) {
            if (illness.diagnosed()) {
                this.prescribeButton = ECButton.Builder.start(this.dx(5), this.dy(currentY), 90, 20).withLabel(I18n.getLabel("horse-illnesses.menu.button.prescribe.label")).withOnClick(() -> onPrescribeClick.accept(illness)).complete();
                this.diagnoseButton = null;
            } else {
                this.diagnoseButton = ECButton.Builder.start(this.dx(5), this.dy(currentY), 90, 20).withLabel(I18n.getLabel("horse-illnesses.menu.button.diagnose.label")).withOnClick(() -> onDiagnoseClick.accept(illness)).complete();
                this.prescribeButton = null;
            }
            currentY += 20;
        } else {
            this.diagnoseButton = null;
            this.prescribeButton = null;
        }
        this.cureProgress = ECProgressBar.Builder.start(this.dx(5), this.dy(currentY), 150).withLabel(I18n.getLabel("horse-illnesses.menu.cure-progress.label")).withValue((int)illness.curePercentage()).withFilledColor(Argb.ARGB_MC_AQUA).complete();
        this.setHeight((currentY += this.cureProgress.m_93694_() + 5) + 5);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.diagnoseButton != null && this.diagnoseButton.m_6375_(mouseX, mouseY, action)) {
            return true;
        }
        if (this.prescribeButton != null && this.prescribeButton.m_6375_(mouseX, mouseY, action)) {
            return true;
        }
        if (!this.diagnosisMode) {
            this.onItemClick.accept(this.illness);
            return true;
        }
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isWithin(mouseX, mouseY)) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, new Argb(150, 200, 200, 200));
        } else {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, new Argb(150, 150, 150, 150));
        }
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.hoursSinceContractedField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.notesField != null) {
            this.notesField.position(this.dx(5), this.dy(this.notesYLevel)).render(poseStack);
        }
        if (this.diagnosisCostField != null) {
            this.diagnosisCostField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.descriptionField.position(this.dx(5), this.dy(this.descriptionYLevel)).render(poseStack);
        if (this.diagnoseButton != null) {
            this.diagnoseButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.prescribeButton != null) {
            this.prescribeButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        this.cureProgress.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

