/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.horse.jobwork;

import com.equestricraft.common.Argb;
import com.equestricraft.core.horse.jobwork.JobWorkCheckInfo;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;

public class JobWorkWidget
extends ECWidget {
    private final JobWorkCheckInfo workCheck;
    private final ECField nameField;
    private final ECMultiLineField descriptionField;
    private final ECField statusField;
    private static final Argb FLAGGED_COLOR = Argb.ARGB_YELLOW.withTransparency(50);

    protected JobWorkWidget(int x, int y, int width, JobWorkCheckInfo workCheck) {
        super(x, y, width, 0);
        this.workCheck = workCheck;
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(workCheck.name()).withValueColor(Argb.ARGB_WHITE).complete();
        int currentY = GuiUtil.getSpacedLineHeight();
        this.descriptionField = ECMultiLineField.Builder.start().withLabel(workCheck.description()).withWidth(width).withPosition(this.dx(0), this.dy(currentY)).complete();
        this.statusField = ECField.Builder.start(this.dx(width), this.dy(0), width).withValue(workCheck.status()).withValueColor(workCheck.statusColor() != null ? workCheck.statusColor() : Argb.ARGB_WHITE).rightAligned().complete();
        this.setHeight(currentY += this.descriptionField.getHeight());
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.workCheck.flagged()) {
            GuiUtil.drawFilledSquare(poseStack, this.dx(0), this.dy(0), this.f_93618_, this.f_93619_, FLAGGED_COLOR);
        }
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.descriptionField.render(poseStack);
        this.statusField.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }
}

